#!/usr/local/bin/python

import sys, os, regsub, html, gif, regex
from assert import FALSE

extensions = ['.html', '.gif', '.jpg']
URLexp = regex.compile('http://\|mailto:\|ftp://')
def getLink(word):
	'''If 'word' is (or can be munged into) some sort of link,
	return the link, otherwise return FALSE.
	'''
	if URLexp.match(word) != -1:
		return '<A HREF="%s">%s</A>' % (word,word)
	filename= findFileName(word)
	if  filename:
		return makeLink(word, filename)
	return None

def findFileName(word):
	'''Try replacing word's extensions with .html, .gif, .jpg,
	then try with plain 'word', then give up
	'''
	root, ext = os.path.splitext(word)
	for e in extensions:
		if simpleFindFileName(word+e):
			return word+e
	if simpleFindFileName(word):
		if os.path.isdir(word):
			return word+'/index.html'
		else:
			return word
	return FALSE

dirs = { }

def simpleFindFileName(name):
	'''Return true if 'name' is an existing file'''
	dir, file = os.path.split(name)
	if not dir:
		dir = '.'
	try:
		listing = dirs[dir]
	except KeyError:
		if os.path.isdir(dir):
			listing = os.listdir(dir)
			# sys.stderr.write("listing for %s: %s\n" % (dir, listing))
		else:
			listing = []
			# sys.stderr.write("bad dir  %s\n" % (dir,))
		dirs[dir] = listing
	return file in listing

def makeLink(word, filename):
	root, ext = os.path.splitext(filename)
	if ext in ['.gif', '.jpg' ] :
		return makeInline(filename)
	else:
		return html.href(filename, regsub.gsub('_', ' ', word))

def makeInline(filename):
	width, height = gif.dim(filename)	# BUG with JPEG files
	return '<IMG SRC="%s" WIDTH="%d" HEIGHT="%d" ALT="%s">' % (filename, width, height, filename)
