# html manipulation stuff

import regsub, string

DEFAULT_TEMPLATE=\
'''<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML><HEAD><TITLE>%(title)s</TITLE></HEAD>
<BODY>
%(body)s
</BODY>
</HTML>
'''

def test():
	print quote('<B>hello</B>')

import regexp
def title(str):
	return '<HTML><HEAD><TITLE>'+str+'</TITLE></HEAD><BODY>'

def tag(type, str):
	return '<'+type+'>' + str + '</'+type+'>'

def quote(str):
	'''quote('<B>fish') -> '&lt;B&gt;fish
	'''
	str = regsub.gsub('&', '&amp;', str)
	str = regsub.gsub('<', '&lt;', str)
	str = regsub.gsub('>', '&gt;', str)
	return str

def starttag(type, attrs):
	str= '<'+type
	for name,val in attrs:
		str = str +' '+ name + '=' + '"' + val + '"'
	str = str+'>'
	return str

def h(level, str):
	return tag('H'+`level`,str)

def h1(str):
	return tag('H1',str)
	
def h2(str):
	return tag('H2',str)

def h3(str):
	return tag('H3',str)

def href(ref, str):
	return '<A HREF="'+ref+'">' + str + '</A>'

def xref(ref, str):
	return '<A NAME="'+ref+'">' + str + '</A>'

def comment(data):
	return '<!--'+data+'-->\n'

def close():
	return '</BODY></HTML>'

# if we're a file, last two elements of list are:
#	current directory, filename
# if we're a directory, last two elements of list are:
#	parent directory, current directory

def refsdir(list):
	depth=len(list)
	retval=''
	for j in range(depth):
		s = '../'*(depth -j -1)
		if not s:
			s= './'
		retval= retval+ href(s, list[j]) + ':\n'
	return retval


def refsfile(list):
	return refsdir(list[:-1])

def fmt(str):
	l = string.split(str)
	lines=[]
	line = []
	length = 0
	for w in l:
		newlength = length + len(w)
		if newlength < 60:
			line.append(w)
			length = newlength
		else:
			lines.append(string.join(line))
			line = [w]
			length = len(w)
	lines.append(string.join(line))
	return string.join(lines, '\n')

