#!/usr/local/bin/python
import string, cgi, traceback, regex
from link import getLink

# dictionary of indicator<->element pairs
style = {
	'_' : 'I',
	'*' : 'B',
	'^' : 'SUP',
	'$' : 'TT',
}
specials = style.keys()	# special characters

WARNING = "warning"

class Stack:
	def __init__(self):
		self.list = []

	def push(self, sym):
		self.list.append(sym)
		
	def pop(self):
		TOS = self.list[-1]
		del self.list[-1:]
		return TOS
		
	def peep(self):
		return self.list[-1]
		
	def empty(self):
		return not self.list

startPunctuationRegex = regex.compile('[,()"]*')
endPunctuationRegex = regex.compile('[.,()"?]*$')
def punctuationSplit(word):
	myword = word
	nmatch = startPunctuationRegex.match(word)
	if nmatch == -1:
		before = ''
	else:
		before = word[:nmatch]
		myword = word[nmatch:]
	pos = endPunctuationRegex.search(myword)
	if pos == -1:
		after = ''
	else:
		after = myword[pos:]
		myword = myword[:pos]
	return before, myword, after
	
def render(lines):
	'''Return HTML rendering of the list of 'lines'.'''
	rendered = []
	stack = Stack()
	for line in lines:
		for word in string.split(line.stripped):
			before, word, after = punctuationSplit(word)
			try:
				link = getLink(word)
				if link:
					rendered.append(before + link + after)
				else:
					styled = cstyle(word, stack)
					rendered.append(before + styled + after)
			except WARNING,s:
				line.warn(s)
				rendered.append(word)
			except:
				line.warn("rendering problem")
				traceback.print_exc()
				
	closeTags = getCloseTags(stack)
	if closeTags:
		lines[-1].warn("unfinished tags: " + closeTags)
		rendered.append(closeTags)
	return string.join(rendered)

def cstyle(word, stack):
	if not word:
		return ''
	myword = cgi.escape(word)
	firstLetter = myword[0]
	start = ''
	end = ''
	if firstLetter in specials:
		myword = myword[1:]
		start = '<' + style[firstLetter] + '>'
		stack.push(firstLetter)
	elif firstLetter == '\\':
		myword = myword[1:]	# strip escape
	lastLetter = myword[-1]
	if lastLetter in specials:
		myword = myword[:-1]
		if stack.empty() or stack.peep() != lastLetter:
			err = "closing " + lastLetter + " without corresponding open"
			raise WARNING, err
		stack.pop()
		end = '</' + style[lastLetter] + '>'
	return start + myword + end

def getCloseTags(stack):
	'''Return a string to close any pending tags on stack'''
	s = ''
	while not stack.empty():
		c = stack.pop()
		s = s + '</'+style[c]+'>'
	return s
