#!/usr/local/bin/python
import html, string, Line
from assert import assert, TRUE, FALSE

class Para:
	'''Extend Chunk by doing cleverer rendering things'''
	
	def __init__(self, indent, parent, lines):
		self.indent = indent
		self.indentString = ' '*indent
		self.parent = parent
		self.lines = lines
		self.children = []	# list of children
		assert (not parent or parent.indent < indent )

	def addLines(self, lines):
		''' If the list of 'lines' forms a complete Para, add it and return true
		'''
		if Line.fullPara(lines):
			self.addPara(lines)
			return TRUE
		else:
			return FALSE
		
	def addPara(self, lines):
		indent = lines[0].indent
		# If we've got here, the indent must be greater
		# than the parent's indentation
		assert(not self.parent or indent > self.parent.indent)
		
		if (indent <= self.indent):
			# add a sibling
			chunk = self.__class__(indent, self.parent, lines)
			self.parent.children.append(chunk)
			if (indent < self.indent):
				lines[0].warn("inconsistent indentation" +
					"--all siblings should have identical indentation")
		elif self.children:
			# hand to child
			self.children[-1].addPara(lines)
		else:
			# create first child
			chunk = self.__class__(indent, self, lines)
			self.children.append(chunk)

	def getTitle(self):
		'''Pick a title from a Chunk hierarchy
		
		Currently uses the first text it can find
		'''
		if self.lines:
			return self.lines[0].quotedHTML()
		elif self.children:
			for c in self.children:
				return c.getTitle()
		else:
			return 'No Title'

	def render(self, mode='HTML'):
		self.renderMode = mode
		return self.renderLines() + self.renderChildren()
		
	def renderLines(self):
		# left-aligned paras are headings
		# first heading is H2, all the others are H3
		if self.indent < 0:
			return ''
		elif self.indent == 0:
			if self.parent.children[0] == self:
				tag = 'H2'
			else:
				tag = 'H3'
			s = Line.render(self.lines, self.renderMode)
			return html.tag(tag, s)+'\n'
		else:
			firstLine = self.lines[0]
			if firstLine.startsWith('|'):
				s = '<PRE>' + Line.example(self.lines, self.renderMode) + '</PRE>'
			elif firstLine.startsWith('='):
				s = Line.literal(self.lines, self.renderMode)
			else:
				s = Line.render(self.lines, self.renderMode)
			return self.indentString + '<LI>' + s + '\n'

	def renderChildren(self):
		if not self.children:
			return ''

		s = string.join(map(lambda x: x.render(), self.children))
		if self.indent<0:
			return s
		else:
			indent = self.indentString
			return  indent + '<UL>\n' + s + indent + '</UL>\n'
