#!/usr/local/bin/python
import sys, regex, string, cgi, Render
from assert import assert, TRUE, FALSE

TABSIZE=8
ws = regex.compile('[ \t][ \t]*')	# whitespace

def getindent(string):
	n = ws.match(string)
	indent = 0
	if n > 0:
		for c in string[:n]:
			if c == '\t':
				indent = indent + TABSIZE
			else:
				indent = indent +1
	return indent

def example(lines, mode):
	'''Return version of 'lines' useful as example
	for rendering in 'mode'
	'''
	s = ''
	base = lines[0].indent
	for line in lines:
		s = s + ' ' * (line.indent - base) + cgi.escape(line.stripped) + '\n'
	return s

def fullPara(lines):
	if lines[0].stripped[0] == '[':
		if lines[-1].stripped[-1] == ']':
			lines[0].stripped= lines[0].stripped[1:]
			lines[-1].stripped = lines[-1].stripped[:-1]
			return TRUE
		else:
			return FALSE
	else:
		return not lines[-1].endsWith('\\')

def literal(lines, mode):
	'''Return literal version of 'lines'
	'''
	return string.join(
			map(lambda x: x.stripped, 
				lines))
	
def render(lines, mode):
	'''Return rendered version of 'lines' for 'mode'
	'''
	return Render.render(lines)

class Line:
	def __init__(self, filename, line, number):
		self.filename = filename
		self.original = line	
		self.number = number	# line number
		self.indent = getindent(line)
		self.stripped = string.strip(line)

	def isComment(self):
		return self.startsWith('#')

	def isEmpty(self):
		return not len(self.stripped)

	def quotedHTML(self):
		'''Return version of self with HTML tags escaped'''
		return cgi.escape(self.stripped)
		
	def startsWith(self, c):
		'''Check if we start with unescaped character 'c'.
		If we do, remove 'c' from the stripped version of our
		string'''
		
		if not len(self.stripped):
			return FALSE
		if self.stripped[0] == c:
			self.stripped = self.stripped [1:]
			return TRUE
		return FALSE
	
	def endsWith(self, c):
		'''Check if we end with unescaped character 'c'.
		If we do, remove 'c' from the stripped version of our
		string'''
		if not len(self.stripped):
			return FALSE
		if self.stripped[-1] == c:
			self.stripped = self.stripped [:-1]
			return TRUE
		return FALSE
	
	def warn(self, msg):
		emsg = "%s:%d %s\n" % (self.filename, self.number, msg)
		sys.stderr.write(emsg)
		
	def __str__(self):
		return self.stripped
	
	def __repr__(self):
		return self.stripped
	
