"""The famous and popular dice game"""

from Tkinter import *
import rand
import tktools


if __name__ == '__main__': inGrail_p = None
else: inGrail_p = 1

Images = []
TooManyRolls = 'TooManyRolls'
AlreadyScored = 'AlreadyScored'
YahtzeeJokerMismatch = 'YahtzeeJokerMismatch'
NUMBER_OF_ROLLS = 3
NUMBER_OF_DICE = 5



# get the images
def init_browser_images(browser):
    if Images: return
    for i in range(1, 7):
	imgurl = 'images/Y%d.gif' % i
	image = browser.get_async_image(imgurl)
	Images.append(image)

def init_raw_images():
    for i in range(1, 7):
	imagefile = 'images/Y%d.gif' % i
	image = PhotoImage(file=imagefile)
	Images.append(image)



class Dice:
    def __init__(self):
	self._die = [0] * NUMBER_OF_DICE
	self._rollcnt = 0
	    
    def roll(self, whichlist=None):
	if self._rollcnt > NUMBER_OF_ROLLS:
	    raise TooManyRolls
	if not whichlist:
	    whichlist = range(0, NUMBER_OF_DICE)
	for which in whichlist:
	    if which > NUMBER_OF_DICE: continue
	    self._die[which] = rand.choice(range(1, 7))
	self._rollcnt = self._rollcnt + 1

    def roll_count(self): return self._rollcnt
    def diefaces(self): return self._die



class DieFace:
    def __init__(self, dieface):
	self._dieface = dieface

    def score(self, dice, joker=None):
	# upper scores ignore yahtzee jokers
	total = 0
	for die in dice.diefaces():
	    if die == self._dieface: total = total + die
	return total


class OfAKind:
    def __init__(self, howmany):
	self._howmany = howmany

    def score(self, dice, joker=None):
	# yahtzee jokers don't affect of-a-kind calculation
	total = 0
	facecount = [0] * 6
	for die in dice.diefaces():
	    facecount[die-1] = facecount[die-1] + 1
	    total = total + die
	legal = None
	for count in facecount:
	    if count >= self._howmany:
		legal = 1
		break
	if legal: return total
	else: return 0


class Yahtzee(OfAKind):
    def __init__(self):
	OfAKind.__init__(self, NUMBER_OF_DICE)

    def score(self, dice, joker=None):
	if joker:
	    raise YahtzeeJokerMismatch
	total = OfAKind.score(self, dice, joker)
	if total > 0:
	    total = 50
	return total


class Straight:
    def __init__(self, small=None):
	if small:
	    self._score = 30
	    self._need = 4
	else:
	    self._score = 40
	    self._need = 5

    def score(self, dice, joker=None):
	if joker:
	    return self._score
	# do real calculation
	facecount = [0] * 6
	for die in dice.diefaces():
	    facecount[die-1] = facecount[die-1] + 1
	inarow = 0
	longest = 0
	for count in facecount:
	    if not count: inarow = 0
	    else: inarow = inarow + 1
	    longest = max(longest, inarow)
	if longest >= self._need:
	    return self._score
	else:
	    return 0

class FullHouse:
    def score(self, dice, joker=None):
	# yahtzee jokers don't affect calculations
	facecount = [0] * 6
	for die in dice.diefaces():
	    facecount[die-1] = facecount[die-1] + 1
	two_found = None
	three_found = None
	for count in facecount:
	    if count == 5:
		two_found = three_found = 1
		break
	    elif count >= 3:
		three_found = 1
	    elif count == 2:
		two_found = 1
	if two_found and three_found: return 25
	return 0

class Chance:
    def score(self, dice, joker=None):
	# yahtzee jokers don't affect calculations
	return reduce(lambda x, y: x+y, dice.diefaces())


## Scoring rules

Rules = [
    DieFace(1), DieFace(2), DieFace(3), DieFace(4), DieFace(5), DieFace(6),
    OfAKind(3), OfAKind(4), Straight(1), Straight(),
    FullHouse(), Chance(), Yahtzee()
    ]



class Score:
    def __init__(self):
	self._score = [None] * 13
	self._yahtzee_bonus = 0

    def score_dice(self, dice, which):
	if self._score[which]:
	    raise AlreadyScored
	# Yahtzee bonus and joker calculation
	joker_able = None
	if Yahtzee().score(dice) == 50:
	    if self._score[-1] == 50:
		self._yahtzee_bonus = self._yahtzee_bonus + 100
	    dieface = dice.diefaces()[0] # all better be the same!
	    if self._score[dieface-1] is not None:
		joker_able = 1
	# get rule and calculate score
	rule = Rules[which]
	score = rule.score(dice, joker_able)
	self._score[which] = score
	# calculate upper and lower total
	upper_total = 0
	upper_bonus = 0
	for i in range(0, 6):
	    if self._score[i] is None: continue
	    upper_total = upper_total + self._score[i]
	# lower total
	lower_total = 0
	for i in range(6, 13):
	    if self._score[i] is None: continue
	    lower_total = lower_total + self._score[i]
	# and upper bonus
	if upper_total >= 63:
	    upper_bonus = 35
	# and total
	total = upper_total + lower_total + upper_bonus + self._yahtzee_bonus
	# now return the values for display
	return {
	    'upper_total': upper_total,
	    'lower_total': lower_total,
	    'upper_bonus': upper_bonus,
	    'yahtzee_bonus': self._yahtzee_bonus,
	    'total': total,
	    }

    def score_of(self, which): return self._score[which]
    def filled_p(self):
	for score in self._score:
	    if score is None: return None
	return 1


class App:
    def __init__(self, master):
	# global initialization
	if inGrail_p: init_browser_images(master.grail_browser)
	self._frame = Frame(master)
	# create the Tcl variables for display. kludgery is necessary
	# because self.__dict__ isn't accessible in restricted
	# execution mode
	self._sdict = {
	    '_upper_bonus': IntVar(),
	    '_upper_total': IntVar(),
	    '_lower_total': IntVar(),
	    '_yahtzee_bonus': IntVar(),
	    '_total': IntVar(),
	    }
	self._upper_bonus = self._sdict['_upper_bonus']
	self._upper_total = self._sdict['_upper_total']
	self._lower_total = self._sdict['_lower_total']
	self._yahtzee_bonus = self._sdict['_yahtzee_bonus']
	self._total = self._sdict['_total']
	self._upper_bonus.set(0)
	self._upper_total.set(0)
	self._lower_total.set(0)
	self._yahtzee_bonus.set(0)
	self._total.set(0)
	# create GUI stuff
	self._frame.pack()
	self._create_dice_buttons()
	self._create_scorefields()
	self._create_controls()
	# create dice
	self._dice = Dice()
	self._score = Score()
	# get things rolling... har, har
	self._roll_all()

    def _create_dice_buttons(self):
	self._dicebtns = []
	self._dforeground = None
	diceframe = Frame(self._frame, relief=RIDGE, borderwidth=2)
	diceframe.pack()
	for die in range(0, 5):
	    # create a variable for the dice button to be bound to
	    var = IntVar()
	    var.set(-1)
	    dframe = Frame(diceframe)
	    dframe.pack(side=LEFT)
	    dlabel = Checkbutton(dframe,
				 image=Images[0],
				 selectimage=Images[0],
				 indicatoron=0,
				 variable=var,
				 state=DISABLED,
				 onvalue=die, offvalue=-1)
	    if not self._dforeground:
		self._dforeground = dlabel['foreground']
	    dlabel.pack()
	    drollbtn = Checkbutton(dframe, variable=var,
				   onvalue=die, offvalue=-1)
	    drollbtn.pack()
	    self._dicebtns.append((dlabel, var, drollbtn))

    def _create_scorefields(self):
	scoreframe = Frame(self._frame)
	scoreframe.pack(side=LEFT)
	uframe = Frame(scoreframe, relief=RIDGE, borderwidth=2)
	uframe.pack(side=LEFT, fill=BOTH)
	lframe = Frame(scoreframe, relief=RIDGE, borderwidth=2)
	lframe.pack(side=LEFT, fill=BOTH)
	# a Tcl variable for holding the value of which scoring button
	# was selected
	self._scorevar = IntVar()
	self._scorevar.set(-1)
	self._buttons = []
	onvalue = 0
	# upper scores
	upper_label = Label(uframe, text='Upper Scores', relief=GROOVE)
	upper_label.pack(fill=BOTH)
	for utitle in ['Aces', 'Twos', 'Threes', 'Fours', 'Fives', 'Sixes']:
	    rowframe = Frame(uframe)
	    rowframe.pack()
	    label = Label(rowframe, text=utitle+':', anchor='e', width=7)
	    label.pack(expand=0, fill=NONE, side=LEFT)
	    value = Radiobutton(rowframe,
				value=onvalue,
				variable=self._scorevar)
	    value.pack(expand=0, fill=NONE, side=LEFT)
	    self._buttons.append(value)
	    onvalue = onvalue + 1
	# upper bonus
	ut_frame = Frame(uframe, relief=GROOVE, borderwidth=2)
	ut_frame.pack(fill=BOTH, side=BOTTOM)
	self._upper_bonus_entry, frame, label = \
	       tktools.make_labeled_form_entry(ut_frame,
					       label='Upper Bonus',
					       entrywidth=3)
	self._upper_bonus_entry.config(textvariable=self._upper_bonus,
				       relief=FLAT,
				       state=DISABLED)
	# upper totals
	self._upper_total_entry, frame, label = \
	       tktools.make_labeled_form_entry(ut_frame,
					       label='Upper Total',
					       entrywidth=3)
	self._upper_total_entry.config(textvariable=self._upper_total,
				       relief=FLAT,
				       state=DISABLED)
	# lower scores
	lower_label = Label(lframe, text='Lower Scores', relief=GROOVE)
	lower_label.pack(fill=BOTH)
	for utitle in ['3 of a Kind', '4 of a Kind', 'Small Straight',
		       'Large Straight', 'Full House', 'Chance', 'Yahtzee']:
	    rowframe = Frame(lframe)
	    rowframe.pack()
	    label = Label(rowframe, text=utitle+':', anchor='e', width=12)
	    label.pack(expand=0, fill=NONE, side=LEFT)
	    value = Radiobutton(rowframe,
				value=onvalue,
				variable=self._scorevar)
	    value.pack(expand=0, fill=NONE, side=LEFT)
	    self._buttons.append(value)
	    onvalue = onvalue + 1
	# lower bonus
	lt_frame = Frame(lframe, relief=GROOVE, borderwidth=2)
	lt_frame.pack(fill=BOTH)
	# lower totals
	self._lower_total_entry, frame, label = \
	       tktools.make_labeled_form_entry(lt_frame,
					       label='Lower Total',
					       entrywidth=3)
	self._lower_total_entry.config(textvariable=self._lower_total,
				       relief=FLAT,
				       state=DISABLED)
	# yahtzee bonus
	self._yahtzee_bonus_entry, frame, label = \
	       tktools.make_labeled_form_entry(lt_frame,
					       label='Yahtzee Bonus',
					       entrywidth=3)
	self._yahtzee_bonus_entry.config(textvariable=self._yahtzee_bonus,
					 relief=FLAT,
					 state=DISABLED)

    def _create_controls(self):
	ctrlframe = Frame(self._frame)
	ctrlframe.pack(side=LEFT, fill=BOTH, expand=1)
	self._rollbtn = Button(ctrlframe, text='Roll All',
			       command=self.roll_cmd)
	self._rollbtn.pack()
	spacer = Label(ctrlframe, text=' ')
	spacer.pack()
	self._scorebtn = Button(ctrlframe, text='Score It',
				command=self.score_cmd,
				state=DISABLED)
	self._scorebtn.pack()
	totallabel = Label(ctrlframe, text='Total Score:')
	totallabel.pack()
	total = Label(ctrlframe, textvariable=self._total, relief=FLAT)
	total.pack()
	self._replaybtn = Button(ctrlframe, text='Play Again', state=DISABLED,
				 command=self.replay)
	self._replaybtn.pack(side=BOTTOM)

    def roll_cmd(self, event=None):
	rollcnt = self._dice.roll_count()
	which = None
	if rollcnt <> 0:
	    which = []
	    for label, var, btn in self._dicebtns:
		value = var.get()
		if value >= 0: which.append(value)
		var.set(-1)
	    if not which:
		self._frame.bell()
		return
	self._dice.roll(which)
	rollcnt = self._dice.roll_count()
	newstate = NORMAL
	if rollcnt >= NUMBER_OF_ROLLS:
	    self._rollbtn.config(state=DISABLED)
	    newstate = DISABLED
	else:
	    self._rollbtn.config(text='Re-roll')
	diefaces = self._dice.diefaces()
	face = 0
	for label, var, btn in self._dicebtns:
	    label.config(image=Images[diefaces[face]-1],
			 selectimage=Images[diefaces[face]-1],
			 disabledforeground = self._dforeground,
			 state=newstate)
	    btn.config(state=newstate)
	    face = face + 1
	self._scorebtn.config(state=NORMAL)

    def _roll_all(self):
	# update the roll buttons
	self._rollbtn.config(text='Roll All', state=NORMAL)
	for label, var, btn in self._dicebtns:
	    var.set(-1)
	    label.config(state=DISABLED)
	    btn.config(state=DISABLED)
	self._dice = Dice()

    def score_cmd(self, event=None):
	diefaces = self._dice.diefaces()
	# figure out which field to score
	score_it = self._scorevar.get()
	if score_it < 0:
	    self._frame.bell()
	    return
	self._scorevar.set(-1)
	# calculate the scores
	scores = self._score.score_dice(self._dice, score_it)
	for key in scores.keys():
	    # can't use self.__dict__ here because it's not accessible
	    # in the applet's restricted execution mode
	    var = self._sdict['_' + key]
	    var.set(scores[key])
	# update the score fields
	button = self._buttons[score_it]
	score_of = self._score.score_of(score_it)
	self._buttons[score_it] = Label(button.master,
					text='%d' % score_of)
	self._buttons[score_it].pack()
	button.destroy()
	# update replay button
	if self._score.filled_p():
	    self._replaybtn.config(state=NORMAL)
	    self._rollbtn.config(state=DISABLED)
	else: self._roll_all()
	self._scorebtn.config(state=DISABLED)

    def replay(self, event=None):
	self._upper_bonus.set(0)
	self._upper_total.set(0)
	self._lower_total.set(0)
	self._yahtzee_bonus.set(0)
	self._total.set(0)
	buttons = []
	onvalue = 0
	for button in self._buttons:
	    newbutton = Radiobutton(button.master,
				    value = onvalue,
				    variable=self._scorevar)
	    newbutton.pack(expand=0, fill=NONE, side=LEFT)
	    buttons.append(newbutton)
	    button.destroy()
	    onvalue = onvalue + 1
	self._buttons = buttons
	self._replaybtn.config(state=DISABLED)
	self._roll_all()
	self._score = Score()
	self._scorebtn.config(state=DISABLED)


if not inGrail_p:
    root = Tk()
    init_raw_images()
    app = App(root)
    root.mainloop()
