"""\
Author: Moshe Zadka <mzadka@geocities.com>

Copyright (c) Moshe Zadka, 1999
All rights reserved.

redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

  o Redistributions of source code must retain the above copyright
    notice, this list of conditions, and the disclaimer that follows.

  o Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions, and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

  o Redistributions of source code must retain the above copyright
    notice, this list of conditions, and the disclaimer that follows.

  o Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions, and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.

  o The name of the contributor may not be used to endorse or promote 
    products derived from this software without specific prior written 
    permission.


THIS SOFTWARE IS PROVIDED BY *AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND 
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
AUTHOR CREATIONS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.

postit is a module for textual notes.

It supports the notion of a postit directory, which it guesses based
on the environment variable POSTIT, a sub-directory named "post-it"
in the environment variable HOME, or a directory named "post-it" relative
to the default directory.

In this directory reside notes the interface to which resides here:
You can make a new note, (the 'new' method), list all notes (the 'list'
method), or remove a note (the 'remove' method). 
"""

import os, cPickle, string

try:
	postit_dir=os.environ['POSTIT']
except KeyError:
	try:
		postit_dir=os.path.join(os.environ['HOME'],'post-it')
	except KeyError:
		postit_dir='post-it'

if not os.path.exists(postit_dir): os.mkdir(postit_dir)
if not os.path.isdir(postit_dir): raise ValueError, \
                                         postit_dir+' not a directory'

_open=open

def _join(file):
	return os.path.join(postit_dir, file)

def _make_title(text):
	title=string.split(text, '\n')[0]
	if len(title)>70:
		title=title[:67]+'...'
	return title

def new(text, title=None):
	"""\
	make a new note.

	Arguments:

	text -- the text of the note
	title -- the title (defaults to the first line of the text, 
	or at least its beginning).
	"""
	if not title:
		title=_make_title(text)
	init=0
	while os.path.exists(_join(str(init))):
		init=init+1
	file=open(_join(str(init)), 'w')
	cPickle.dump((title, text), file)
	file.close()

def list():
	"""\
	return a list of (title, text) pairs

	Arguments: none
	"""
	ret=[]
	for name in os.listdir(postit_dir):
		ret.append(cPickle.load(open(_join(name))))
	return ret

def remove(title):
	"""\
	remove a note with a given title

	Arguments:

	title -- the title of the note to remove
	"""
	for name in os.listdir(postit_dir):
		if cPickle.load(open(_join(name)))[0]==title:
			os.remove(_join(name))
