/***********************************************************
Copyright 1991-1995 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include <Python.h>

static PyObject* ErrorObject;

static PyObject* error( const char* msg )
  {
  PyErr_SetString( ErrorObject, (char*)msg );
  return 0;
  }

/* File containing module implementation macros */
#include "sample_impl.i"

/* ----------------------------------------------------- */
#ifndef sample_newsimple_impl
static PyObject * sample_newsimple_(PyObject *args);
#endif
#ifndef sample_newnumberish_impl
static PyObject * sample_newnumberish_(PyObject *args);
#endif
#ifndef sample_newott_impl
static PyObject * sample_newott_(PyObject *args);
#endif
/* File containing implementations for simple object */
#include "simp_impl.i"

/* Declarations for objects of type simple object */

typedef struct simpObject {
	PyObject_HEAD
	/* Add your own stuff with this macro */
#ifdef simp_struct
	simp_struct
#endif
} simpObject;

/* ---------------------------------------------------------------- */
staticforward PyObject* simp_sample(simpObject *self, PyObject *args);
#ifndef simp_sample_impl
staticforward PyObject* simp_sample_(simpObject *self, PyObject *args);
#endif
staticforward PyObject * simp_getattr(simpObject *self, char *name);
staticforward simpObject* simp_New();

static PyTypeObject SimpType = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"simple object",			/*tp_name*/
	sizeof(simpObject),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)0,	/*tp_dealloc*/
	(printfunc)0,		/*tp_print*/
	(getattrfunc)simp_getattr,	/*tp_getattr*/
	(setattrfunc)0,	/*tp_setattr*/
	(cmpfunc)0,		/*tp_compare*/
	(reprfunc)0,		/*tp_repr*/
	0,			/*tp_as_number*/
	0,		/*tp_as_sequence*/
	0,		/*tp_as_mapping*/
	(hashfunc)0,		/*tp_hash*/
};

#define simp_Check(v)		((v)->ob_type == &SimpType)

/* ---------------------------------------------------------------- */
/* File containing implementations for number-like object */
#include "nl_impl.i"

/* Declarations for objects of type number-like object */

typedef struct nlObject {
	PyObject_HEAD
	/* Add your own stuff with this macro */
#ifdef nl_struct
	nl_struct
#endif
} nlObject;

/* ---------------------------------------------------------------- */
staticforward nlObject* nl_New();
staticforward PyObject * nl_repr(nlObject *self);
staticforward int nl_compare(nlObject *v, nlObject *w);
staticforward object * nl_add(nlObject *v, nlObject *w);
staticforward object * nl_sub(nlObject *v, nlObject *w);
staticforward object * nl_mul(nlObject *v, nlObject *w);
staticforward object * nl_div(nlObject *v, nlObject *w);
staticforward object * nl_mod(nlObject *v, nlObject *w);
staticforward PyObject * nl_divmod(nlObject *v, nlObject *w);
staticforward PyObject * nl_pow(nlObject *v, nlObject *w, nlObject *z);
staticforward PyObject * nl_neg(nlObject *v);
staticforward PyObject * nl_pos(nlObject *v);
staticforward PyObject * nl_abs(nlObject *v);
staticforward int nl_nonzero(nlObject *v);
staticforward PyObject * nl_invert(nlObject *v);
staticforward PyObject * nl_lshift(nlObject *v, nlObject *w);
staticforward PyObject * nl_rshift(nlObject *v, nlObject *w);
staticforward PyObject * nl_and(nlObject *v, nlObject *w);
staticforward PyObject * nl_xor(nlObject *v, nlObject *w);
staticforward PyObject * nl_or(nlObject *v, nlObject *w);
staticforward int nl_coerce(nlObject *v, nlObject *w);
staticforward PyObject * nl_int(nlObject *v);
staticforward PyObject * nl_long(nlObject *v);
staticforward PyObject * nl_float(nlObject *v);
staticforward PyObject * nl_oct(nlObject *v);
staticforward PyObject * nl_hex(nlObject *v);

#ifndef nl_add_impl
staticforward object * nl_add_(nlObject *v, nlObject *w);
#endif
#ifndef nl_sub_impl
staticforward object * nl_sub_(nlObject *v, nlObject *w);
#endif
#ifndef nl_mul_impl
staticforward object * nl_mul_(nlObject *v, nlObject *w);
#endif
#ifndef nl_div_impl
staticforward object * nl_div_(nlObject *v, nlObject *w);
#endif
#ifndef nl_mod_impl
staticforward object * nl_mod_(nlObject *v, nlObject *w);
#endif
#ifndef nl_divmod_impl
staticforward PyObject * nl_divmod_(nlObject *v, nlObject *w);
#endif
#ifndef nl_pow_impl
staticforward PyObject * nl_pow_(nlObject *v, nlObject *w, nlObject *z);
#endif
#ifndef nl_neg_impl
staticforward PyObject * nl_neg_(nlObject *v);
#endif
#ifndef nl_pos_impl
staticforward PyObject * nl_pos_(nlObject *v);
#endif
#ifndef nl_abs_impl
staticforward PyObject * nl_abs_(nlObject *v);
#endif
#ifndef nl_nonzero_impl
staticforward int nl_nonzero_(nlObject *v);
#endif
#ifndef nl_invert_impl
staticforward PyObject * nl_invert_(nlObject *v);
#endif
#ifndef nl_lshift_impl
staticforward PyObject * nl_lshift_(nlObject *v, nlObject *w);
#endif
#ifndef nl_rshift_impl
staticforward PyObject * nl_rshift_(nlObject *v, nlObject *w);
#endif
#ifndef nl_and_impl
staticforward PyObject * nl_and_(nlObject *v, nlObject *w);
#endif
#ifndef nl_xor_impl
staticforward PyObject * nl_xor_(nlObject *v, nlObject *w);
#endif
#ifndef nl_or_impl
staticforward PyObject * nl_or_(nlObject *v, nlObject *w);
#endif
#ifndef nl_coerce_impl
staticforward int nl_coerce_(nlObject *v, nlObject *w);
#endif
#ifndef nl_int_impl
staticforward PyObject * nl_int_(nlObject *v);
#endif
#ifndef nl_long_impl
staticforward PyObject * nl_long_(nlObject *v);
#endif
#ifndef nl_float_impl
staticforward PyObject * nl_float_(nlObject *v);
#endif
#ifndef nl_oct_impl
staticforward PyObject * nl_oct_(nlObject *v);
#endif
#ifndef nl_hex_impl
staticforward PyObject * nl_hex_(nlObject *v);
#endif

static number_methods nl_as_number = {
	(binaryfunc)nl_add,	/*nb_add*/
	(binaryfunc)nl_sub,	/*nb_subtract*/
	(binaryfunc)nl_mul,	/*nb_multiply*/
	(binaryfunc)nl_div,	/*nb_divide*/
	(binaryfunc)nl_mod,	/*nb_remainder*/
	(binaryfunc)nl_divmod,	/*nb_divmod*/
	(ternaryfunc)nl_pow,	/*nb_power*/
	(unaryfunc)nl_neg,	/*nb_negative*/
	(unaryfunc)nl_pos,	/*nb_positive*/
	(unaryfunc)nl_abs,	/*nb_absolute*/
	(inquiry)nl_nonzero,	/*nb_nonzero*/
	(unaryfunc)nl_invert,	/*nb_invert*/
	(binaryfunc)nl_lshift,	/*nb_lshift*/
	(binaryfunc)nl_rshift,	/*nb_rshift*/
	(binaryfunc)nl_and,	/*nb_and*/
	(binaryfunc)nl_xor,	/*nb_xor*/
	(binaryfunc)nl_or,	/*nb_or*/
	(coercion)nl_coerce,	/*nb_coerce*/
	(unaryfunc)nl_int,	/*nb_int*/
	(unaryfunc)nl_long,	/*nb_long*/
	(unaryfunc)nl_float,	/*nb_float*/
	(unaryfunc)nl_oct,	/*nb_oct*/
	(unaryfunc)nl_hex,	/*nb_hex*/
};

/* ------------------------------------------------------- */

static PyTypeObject NlType = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"number-like object",			/*tp_name*/
	sizeof(nlObject),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)0,	/*tp_dealloc*/
	(printfunc)0,		/*tp_print*/
	(getattrfunc)0,	/*tp_getattr*/
	(setattrfunc)0,	/*tp_setattr*/
	(cmpfunc)nl_compare,		/*tp_compare*/
	(reprfunc)nl_repr,		/*tp_repr*/
	&nl_as_number,			/*tp_as_number*/
	0,		/*tp_as_sequence*/
	0,		/*tp_as_mapping*/
	(hashfunc)0,		/*tp_hash*/
};

#define nl_Check(v)		((v)->ob_type == &NlType)

/* ---------------------------------------------------------------- */
/* File containing implementations for over-the-top object */
#include "ot_impl.i"

/* Declarations for objects of type over-the-top object */

typedef struct otObject {
	PyObject_HEAD
	/* Add your own stuff with this macro */
#ifdef ot_struct
	ot_struct
#endif
} otObject;

/* ---------------------------------------------------------------- */
staticforward PyObject* ot_method1(otObject *self, PyObject *args);
#ifndef ot_method1_impl
staticforward PyObject* ot_method1_(otObject *self, PyObject *args);
#endif
staticforward PyObject* ot_method2(otObject *self, PyObject *args);
#ifndef ot_method2_impl
staticforward PyObject* ot_method2_(otObject *self, PyObject *args);
#endif
staticforward otObject* ot_New();
staticforward void ot_dealloc(otObject *self);
staticforward int ot_print(otObject *self, FILE *fp, int flags);
staticforward int ot_compare(otObject *v, otObject *w);
staticforward PyObject * ot_repr(otObject *self);
staticforward long ot_hash(otObject *self);
staticforward int ot_length(otObject *self);
staticforward PyObject * ot_concat(otObject *self, PyObject *bb);
staticforward PyObject * ot_repeat(otObject *self, int n);
staticforward PyObject * ot_item(otObject *self, int i);
staticforward PyObject * ot_slice(otObject *self, int ilow, int ihigh);
staticforward int ot_ass_item(otObject *self, int i, PyObject *v);
staticforward int ot_ass_slice(PyListObject *self, int ilow, int ihigh, PyObject *v);

#ifndef ot_length_impl
staticforward int ot_length_(otObject *self);
#endif
#ifndef ot_concat_impl
staticforward PyObject * ot_concat_(otObject *self, PyObject *bb);
#endif
#ifndef ot_repeat_impl
staticforward PyObject * ot_repeat_(otObject *self, int n);
#endif
#ifndef ot_item_impl
staticforward PyObject * ot_item_(otObject *self, int i);
#endif
#ifndef ot_slice_impl
staticforward PyObject * ot_slice_(otObject *self, int ilow, int ihigh);
#endif
#ifndef ot_ass_item_impl
staticforward int ot_ass_item_(otObject *self, int i, PyObject *v);
#endif
#ifndef ot_ass_slice_impl
staticforward int ot_ass_slice_(PyListObject *self, int ilow, int ihigh, PyObject *v);
#endif

static sequence_methods ot_as_sequence = {
	(inquiry)ot_length,		/*sq_length*/
	(binaryfunc)ot_concat,		/*sq_concat*/
	(intargfunc)ot_repeat,		/*sq_repeat*/
	(intargfunc)ot_item,		/*sq_item*/
	(intintargfunc)ot_slice,		/*sq_slice*/
	(intobjargproc)ot_ass_item,	/*sq_ass_item*/
	(intintobjargproc)ot_ass_slice,	/*sq_ass_slice*/
};

/* -------------------------------------------------------------- */
/* EMPTY */

static PyTypeObject OtType = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"over-the-top object",			/*tp_name*/
	sizeof(otObject),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)ot_dealloc,	/*tp_dealloc*/
	(printfunc)ot_print,		/*tp_print*/
	(getattrfunc)ot_getattr,	/*tp_getattr*/
	(setattrfunc)ot_setattr,	/*tp_setattr*/
	(cmpfunc)ot_compare,		/*tp_compare*/
	(reprfunc)ot_repr,		/*tp_repr*/
	0,			/*tp_as_number*/
	&ot_as_sequence,		/*tp_as_sequence*/
	0,		/*tp_as_mapping*/
	(hashfunc)ot_hash,		/*tp_hash*/
};

#define ot_Check(v)		((v)->ob_type == &OtType)

/* ---------------------------------------------------------------- */

static PyObject *
simp_sample(simpObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef simp_sample_impl
        simp_sample_impl(self, args);
#else
	return simp_sample_(self, args);
#endif
}

static PyMethodDef simp_methods[] = {
	{"sample",	(PyCFunction)simp_sample,	1},
 
	{NULL,		NULL}		/* sentinel */
};

/* ---------- */

static PyObject *
simp_getattr(simpObject *self, char *name)
{
	/* Add your own getattr in macro */
#ifdef simp_getattr_impl
	simp_getattr_impl(self, name)
#else
	simp_getattr_(self, name)
#endif
	return Py_FindMethod(simp_methods, (PyObject *)self, name);
}

static simpObject *
simp_New()
{
	simpObject *self;
	
	self = PyObject_NEW(simpObject, &SimpType);
	if (self == NULL)
		return NULL;
	/* Initialition macro */
#ifdef simp_New_impl
	simp_New_impl(self)
#else
	simp_New_(self)
#endif
	return self;
}
#ifdef simp_TAIL
#include "simp_tail.i"
#endif

/* End of code for simple object objects */
/* -------------------------------------------------------- */

static PyMethodDef nl_methods[] = {
	
	{NULL,		NULL}		/* sentinel */
};

/* ---------- */

static nlObject *
nl_New()
{
	nlObject *self;
	
	self = PyObject_NEW(nlObject, &NlType);
	if (self == NULL)
		return NULL;
	/* Initialition macro */
#ifdef nl_New_impl
	nl_New_impl(self)
#else
	nl_New_(self)
#endif
	return self;
}

static PyObject *
nl_repr(nlObject *self)
{
	PyObject *s = 0;

	/* Add code here to put self into s */
#ifdef nl_repr_impl
	nl_repr_impl(self, s)
#else
	nl_repr_(self, s)
#endif
	return s;
}

static int
nl_compare(nlObject *v, nlObject *w)
{
	/* Compare objects and return -1, 0 or 1 */
#ifdef nl_compare_impl
	nl_compare_impl(v, w)
#endif
	nl_compare_(v, w)
#endif
}
/* Code to access number-like object objects as numbers */

static object *
nl_add(nlObject *v, nlObject *w)
{
	/* XXXX Add them */
#ifdef nl_add_impl
	nl_add_impl(v, w)
#else
	nl_add_(v, w)
#endif
}

static object *
nl_sub(nlObject *v, nlObject *w)
{
	/* XXXX Subtract them */
#ifdef nl_sub_impl
	nl_sub_impl(v, w)
#else
	nl_sub_(v, w)
#endif
}

static object *
nl_mul(nlObject *v, nlObject *w)
{
	/* XXXX Multiply them */
#ifdef nl_mul_impl
	nl_mul_impl(v, w)
#else
	nl_mul_(v, w)
#endif
}

static object *
nl_div(nlObject *v, nlObject *w)
{
	/* XXXX Divide them */
#ifdef nl_div_impl
	nl_div_impl(v, w)
#else
	nl_div_(v, w)
#endif
}

static object *
nl_mod(nlObject *v, nlObject *w)
{
	/* XXXX Modulo them */
#ifdef nl_mod_impl
	nl_mod_impl(v, w)
#else
	nl_mod_(v, w)
#endif
}

static PyObject *
nl_divmod(nlObject *v, nlObject *w)
{
	/* XXXX Return 2-tuple with div and mod */
#ifdef nl_divmod_impl
	nl_divmod_impl(v, w)
#else
	nl_divmod_(v, w)
#endif
}

static PyObject *
nl_pow(nlObject *v, nlObject *w, nlObject *z)
{
#ifdef nl_pow_impl
	nl_pow_impl(v, w, z)
#else
	nl_pow_(v, w, z)
#endif
}				

static PyObject *
nl_neg(nlObject *v)
{
#ifdef nl_neg_impl
	nl_neg_impl(v)
#else
	nl_neg_(v)
#endif
}

static PyObject *
nl_pos(nlObject *v)
{
#ifdef nl_pos_impl
	nl_pos_impl(v)
#else
	nl_pos_(v)
#endif
}

static PyObject *
nl_abs(nlObject *v)
{
#ifdef nl_abs
	nl_abs_impl(v)
#else
	nl_abs_(v)
#endif
}

static int
nl_nonzero(nlObject *v)
{
	/* XXXX Return 1 if non-zero */
#ifdef nl_nonzero_impl
	nl_nonzero_impl(v)
#else
	nl_nonzero_(v)
#endif
}

static PyObject *
nl_invert(nlObject *v)
{
#ifdef nl_invert_impl
	nl_invert_impl(v)
#else
	nl_invert_(v)
#endif
}

static PyObject *
nl_lshift(nlObject *v, nlObject *w)
{
#ifdef nl_lshift_impl
	nl_lshift_impl(v, w)
#else
	nl_lshift_(v, w)
#endif
}

static PyObject *
nl_rshift(nlObject *v, nlObject *w)
{
#ifdef nl_rshift_impl
	nl_rshift_impl(v, w)
#else
	nl_rshift_(v, w)
#endif
}

static PyObject *
nl_and(nlObject *v, nlObject *w)
{
#ifdef nl_and_impl
	nl_and_impl(v, w)
#else
	nl_and_(v, w)
#endif
}

static PyObject *
nl_xor(nlObject *v, nlObject *w)
{
#ifdef nl_xor_impl
	nl_xor_impl(v, w)
#else
	nl_xor_(v, w)
#endif
}

static PyObject *
nl_or(nlObject *v, nlObject *w)
{
#ifdef nl_or_impl
	nl_or_impl(v, w)
#else
	nl_or_(v, w)
#endif
}

static int
nl_coerce(nlObject *v, nlObject *w)
{
	/* XXXX I haven't a clue... */
#ifdef nl_coerce_impl
	nl_coerce_impl(v, w)
#else
	nl_coerce_(v, w)
#endif
	return 1;
}

static PyObject *
nl_int(nlObject *v)
{
#ifdef nl_int_impl
	nl_int_impl(v)
#else
	nl_int_(v)
#endif
}

static PyObject *
nl_long(nlObject *v)
{
#ifdef nl_long_impl
	nl_long_impl(v)
#else
	nl_long_(v)
#endif
}

static PyObject *
nl_float(nlObject *v)
{
#ifdef nl_float_impl
	nl_float_impl(v)
#else
	nl_float_(v)
#endif
}

static PyObject *
nl_oct(nlObject *v)
{
	/* Return object as octal stringobject */
#ifdef nl_oct_impl
	nl_oct_impl(v)
#else
	nl_oct_(v)
#endif
}

static PyObject *
nl_hex(nlObject *v)
{
	/* Return object as hex stringobject */
#ifdef nl_hex_impl
	nl_hex_impl(v)
#else
	nl_hex_(v)
#endif
}

/* ------------------------------------------------------- */
#ifdef nl_TAIL
#include "nl_tail.i"
#endif

/* End of code for number-like object objects */
/* -------------------------------------------------------- */

static PyObject *
ot_method1(otObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef ot_method1_impl
        ot_method1_impl(self, args);
#else
	return ot_method1_(self, args);
#endif
}

static PyObject *
ot_method2(otObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef ot_method2_impl
        ot_method2_impl(self, args);
#else
	return ot_method2_(self, args);
#endif
}

static PyMethodDef ot_methods[] = {
	{"method1",	(PyCFunction)ot_method1,	1},
 {"method2",	(PyCFunction)ot_method2,	1},
 
	{NULL,		NULL}		/* sentinel */
};

/* ---------- */

static otObject *
ot_New()
{
	otObject *self;
	
	self = PyObject_NEW(otObject, &OtType);
	if (self == NULL)
		return NULL;
	/* Initialition macro */
#ifdef ot_New_impl
	ot_New_impl(self)
#else
	ot_New_(self)
#endif
	return self;
}

static void
ot_dealloc(otObject *self)
{
	/* XXXX Add your own cleanup code here */
#ifdef ot_dealloc_impl
	ot_dealloc_impl(self)
#endif
	ot_dealloc_(self)
#endif
	PyMem_DEL(self);
}

static int
ot_print(otObject *self, FILE *fp, int flags)
{
	/* XXXX Add code here to print self to fp */
#ifdef ot_print_impl
	ot_print_impl(self, fp, flags)
#else
	ot_print_(self, fp, flags)
#endif
}

static int
ot_compare(otObject *v, otObject *w)
{
	/* Compare objects and return -1, 0 or 1 */
#ifdef ot_compare_impl
	ot_compare_impl(v, w)
#endif
	ot_compare_(v, w)
#endif
}

static PyObject *
ot_repr(otObject *self)
{
	PyObject *s = 0;

	/* Add code here to put self into s */
#ifdef ot_repr_impl
	ot_repr_impl(self, s)
#else
	ot_repr_(self, s)
#endif
	return s;
}

static long
ot_hash(otObject *self)
{
	/* Return a hash of self (or -1) */
#ifdef ot_hash_impl
	ot_hash_impl(self)
#else
	ot_hash_(self)
#endif
}

/* Code to handle accessing over-the-top object objects as sequence objects */

static int
ot_length(otObject *self)
{
	/* Return the size of the object */
#ifdef ot_length_impl
	ot_length_impl(self)
#else
	ot_length_(self)
#endif
}

static PyObject *
ot_concat(otObject *self, PyObject *bb)
{
	/* Return the concatenation of self and bb */
#ifdef ot_concat_impl
	ot_concat_impl(self, bb)
#else
	ot_concat_(self, bb)
#endif
}

static PyObject *
ot_repeat(otObject *self, int n)
{
	/* XXXX Return a new object that is n times self */
#ifdef ot_repeat_impl
	ot_repeat_impl(self, n)
#else
	ot_repeat_(self. n)
#endif
}

static PyObject *
ot_item(otObject *self, int i)
{
	/* XXXX Return the i-th object of self */
#ifdef ot_item_impl
	ot_item_impl(self, i)
#else
	ot_item_(self, i)
#endif
}

static PyObject *
ot_slice(otObject *self, int ilow, int ihigh)
{
	/* XXXX Return the ilow..ihigh slice of self in a new object */
#ifdef ot_slice_impl
	ot_slice_impl(self, ilow, ihigh)
#else
	ot_slice_(self, ilow, ihigh)
#endif
}

static int
ot_ass_item(otObject *self, int i, PyObject *v)
{
	/* XXXX Assign to the i-th element of self */
#ifdef ot_ass_item_impl
	ot_ass_item_impl(self, i, v)
#else
	ot_ass_item_(self, i, v)
#endif
	return 0;
}

static int
ot_ass_slice(PyListObject *self, int ilow, int ihigh, PyObject *v)
{
	/* XXXX Replace ilow..ihigh slice of self with v */
#ifdef ot_ass_slice_impl
	ot_ass_slice_impl(self, ilow, ihigh, v)
#else
	ot_ass_slice_(self, ilow, ihigh, v)
#endif
	return 0;
}

/* -------------------------------------------------------------- */
/* Code to access structure members by accessing attributes */

#include "structmember.h"

#define OFF(x) offsetof(otObject, x)

static struct memberlist ot_memberlist[] = {
	/* $abbrev_members should contain lines like { "foo", T_INT, OFF(foo), RO }  */
	ot_members,
	{NULL}	/* Sentinel */
};

static PyObject *
ot_getattr(otObject *self, char *name)
{
	PyObject *rv;
	
	rv = PyMember_Get((char *)ot_struct, ot_memberlist, name);
	if (rv)
		return rv;
	PyErr_Clear();
	return Py_FindMethod(ot_methods, (PyObject *)self, name);
}


static int
ot_SetAttr(otObject *self, char *name, PyObject *v)
{
	if ( v == NULL ) {
		PyErr_SetString(PyExc_AttributeError, "Cannot set attribute");
		return -1;
	}
	return PyMember_Set((char *)ot_struct, ot_memberlist, name, v);
}
#ifdef ot_TAIL
#include "ot_tail.i"
#endif

/* End of code for over-the-top object objects */
/* -------------------------------------------------------- */

static PyObject *
sample_newsimple(PyObject *, PyObject *args)
{
	/* Either use macro or separate function */
#ifdef sample_newsimple_impl
	sample_newsimple_impl(args);
#else
	return sample_newsimple_(args);
#endif
}

static PyObject *
sample_newnumberish(PyObject *, PyObject *args)
{
	/* Either use macro or separate function */
#ifdef sample_newnumberish_impl
	sample_newnumberish_impl(args);
#else
	return sample_newnumberish_(args);
#endif
}

static PyObject *
sample_newott(PyObject *, PyObject *args)
{
	/* Either use macro or separate function */
#ifdef sample_newott_impl
	sample_newott_impl(args);
#else
	return sample_newott_(args);
#endif
}

/* List of methods defined in the module */

static PyMethodDef sample_methods[] = {
	{"newsimple",	(PyCFunction)sample_newsimple,	1},
 {"newnumberish",	(PyCFunction)sample_newnumberish,	1},
 {"newott",	(PyCFunction)sample_newott,	1},
 
	{NULL,		NULL}		/* sentinel */
};

#ifdef sample_TAIL
#include "sample_tail.i"
#endif


/* Initialization function for the module (*must* be called initsample) */

#ifdef __cplusplus
extern "C"
#endif
void
initsample()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule("sample", sample_methods);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("sample.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
#ifdef sample_constants
	sample_constants(d)
#endif
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module sample");
}
