#line 24 "interscript_languages.ipk"
from interscript.encoding.utf8 import utf8
import re

interscript_phrases = {
  'Contents': {
    'es': "Contenidos"
   },
  'Table of Contents': {
    'es': 'Tabla de contenidos',
    'it': 'Indice',
    'pt':'\u00CDndicie',
    'fr':'Table des mati\u00E8res',
    'de':'Inhaltsverzeichnis'
  },
  'Next': {
    'es': 'Siguiente',
    'fr': 'Ensuite',
    'de': 'Folgende',
    'it': 'Seguente'
  },
  'Prev': {
    'es': 'Previo',
    'fr': 'Pr\u00E9c\u00E9dent',
    'de': 'Vorige'
  },
  'First': {
    'es': 'Primero',
    'de': 'Erste',
    'fr': 'Premi\u00E8re',
    'it': 'Primo',
    'pt': 'Primeira',
    'el': '\u03A0\u03C1\u03CE\u03C4\u03B7',
    'nl': 'Eerste'
  },
  'Last': {
    'es': '\u00DAltimo',
    'fr':'Dernier'
  },
  'Classes': {
    'es': "Clases",
    'de': 'Kategorien',
    'it': 'Codici Categoria'
  },
  'Functions': {
    'es': "Funciones",
    'de':'Funktionen'
  },
  'Top': {
    'es': "Arriba del todo",
    'fr':'Dessus',
    'de':'Oberseite'
  },
  'Upmost': {
    'es': 'Arriba del todo'
  },
  'Sources': {
    'es': 'Fuentes',
    'de':'Quellen'
  },
  'Identifiers': {
    'es': "Identificadores"
  },
  'Version': {
    'es': 'Versi\u00F3n'
  },
  'Installation': {
    'es': 'Instalación'
  },
  'Requirements': {
    'es': 'Requerimientos'
  },
  'Tests': {
    'de':'Pr\u00FCfen'
  },
  'section': {
    'es': "seccione",
    'it':'sezione'
  },
  'Sections': {
    'es': "Secciones"
  },
  'Tutorial': {
    'fr':"Cours d\u0301instruction"
  },
  'Code': {
    'es':'Código'
  },
  'Start': {
    'es':'Comienzo',
    'de':'Beginnen',
    'pt':'C\u00E7meco',
    },
  'End': {
    'es': 'Fin',
    'it':'estremit\u00E0',
    'de':'Ende',
    'pt':'Extremidade'
  }
}

slash_u = re.compile(r'\\u(....)|\\U(........)')

def parse_escapes(text):
  pos = 0
  s = ''
  match = slash_u.search(text,pos)
  while match:
    first, last = match.start(0), match.end(0)
    s = s + text[pos:first]
    if match.group(1): hexcode = match.group(1)
    else: hexcode = match.group(2)
    value = hexval(hexcode)
    utf = utf8(value)
    s = s + utf
    pos = last
    match = slash_u.search(text,pos)
  s = s + text[pos:]
  return s

def tr_phrase(native_phrase, language):
  x = parse_escapes(native_phrase)
  d = interscript_phrases.get(x,{})
  tr = d.get(language,x)
  return parse_escapes(tr)

def phrase_list():
  keys = interscript_phrases.keys()
  keys.sort()
  return keys

def add_translation(native_phrase, **kwds):
  if not interscript_phrases.has_key(native_phrase):
    interscript_phrases[native_phrase]={}
  interscript_phrases[native_phrase].update(kwds)


