#line 26 "pass_frame.ipk"
import string
import traceback
import sys
import interscript

from interscript.drivers.sources import source_open_error
from interscript.drivers.sources.disk import named_file_source
from interscript.drivers.sources.base import eoi
from interscript.frames.inputf import input_frame
from interscript.weavers.auto import auto_weaver
from interscript.drivers.sources.base import eoi
from interscript.parsers.html import sgml_wrapper, html_filter

class pass_frame:
  def __init__(self,master, passno, skiplist):
    self.skiplist = skiplist
    # the display
    self.master = master
    self.process = master.process
    if 'frames' in self.process.trace:
      self.process.acquire_object(self, 'PASS FRAME')
    self.passno = passno

    self.autoweave = master.autoweave

    self.ids = {}
    self.flist = []
    self.fdict = {}
    self.iflist = []
    self.toc = []
    self.include_files = []
    self.classes = {}
    self.functions = {}
    self.testno = 0
    self.sequence = 0
    self.tests = {}
    self.section_index = {}
    self.ftp_list = []

    if 'weavers' in self.process.trace:
      print 'Autoweave',self.autoweave

    file = self.master.filename
    encoding = self.master.encoding
    encoding = string.replace(string.lower(encoding),'-','_')
    if 'frames' in self.process.trace:
      print 'Processing',file,'Pass',passno+1,'Encoding',encoding

#line 80 "pass_frame.ipk"

    basename = file
    if string.find(file,'.') != -1:
      basename = string.join(string.split(file,'.')[:-1],'.')

    weaver = auto_weaver(self, basename, self.autoweave, master.title)
    userdict = { }

    try:
      input_file =named_file_source(self,file, self.master.source_prefix, encoding = encoding)

    except source_open_error, filename:
      print 'Cannot Open File',filename,'for input (ignored)'
      raise
    except KeyboardError:
      raise
    except:
      print "Program error opening",file
      traceback.print_exc()
      raise

    self.include_files.append((1,'interscript',file))
    inpt = input_frame(
      self,
      input_file,
      [],
      weaver,
      userdict,
      1)
    del input_file
    del weaver
    del userdict

    inpt.set_warning_character(python='@')
    if 'input' in self.process.trace:
      print 'input from',inpt.source.get_source_name()

    inpt.file_pass()
    # at this point, inpt, weaver, userdict, input_file
    # should all be released (even if 'pass_frame' is held onto,
    # these symbols are defined in the __init__ function frame)
    del inpt
    try: raise eoi
    except: pass

  def __del__(self):
    if 'frames' in self.process.trace:
      print 'Processing of',self.master.filename,'Pass',self.passno+1,'complete'
      self.process.release_object(self)

  def get_pass_frame(self):
    return self

  def get_new_test_number(self):
    self.testno = self.testno + 1
    return self.testno

  def get_new_sequence_number(self):
    self.sequence = self.sequence + 1
    return self.sequence

