#line 34 "input_frame.ipk"
import string
import re
import traceback
import sys
import os
import tempfile
from interscript.frames.processf import process_fault

# these imports _should_ come from the global frame!
from interscript.drivers.sources.base import eof, eoi
from interscript.drivers.sources.disk import named_file_source
from interscript.drivers.sources.disk import parse_source_filename
from interscript.drivers.sources.disk import loadfile
from interscript.drivers.sources.cache import cache_source
from interscript.drivers.sinks.bufdisk import named_file_sink
from interscript.drivers.sinks.disk import simple_named_file_sink
from interscript.drivers.sinks.cache import cache_sink
from interscript.drivers.storage.memory import memory
from interscript.languages.interscript_languages import add_translation
from interscript.tanglers.data import data_tangler

from interscript.core.protocols import has_protocol

from interscript.parsers.html import sgml_wrapper, html_filter
try:
  import interscript.utilities.diff
except:
  try: raise "dummy" # correct stupid python bug
  except: pass

def compile_parse_tab(res):
  return map(lambda x: [re.compile(x[0]), x[1]], res)

class deduce: pass

extension_table = {
  'py':'python',
  'c':'c',
  'h':'c',
  'cc':'cpp',
  'cpp':'cpp',
  'cxx':'cpp',
  'hpp':'cpp',
  'hxx':'cpp',
  'java':'java',
  'pl':'perl',
  'pak':'interscript',
  'ipk':'interscript',
  'dat':'data',
  'txt':'data',
  'doc':'doc'
}

#line 95 "input_frame.ipk"
class input_frame:

  def __init__(self, pass_frame, src, reg_list, weaver, userdict, depth):
    # the display
    self.pass_frame = pass_frame
    self.master = pass_frame.master
    self.process = self.master.process
    self.global_frame = self.process.global_frame

    self.current_weaver = weaver
    self.current_weaver_stack = []

    self.depth = depth
    self.source = src
    self.userdict = userdict
    self.reg_list = reg_list
    self.read_buffer = []

    self.current_tangler_stack = []
    self.current_tangler = None
    self.line_offset = 0
    self.original_filename = src.get_source_name()
    self.original_count = self.line_offset
    self.current_weaver.set_original_filename(self.original_filename)
    self.head_offset = 0
    self.tabwidth = self.master.tabwidth

    self.cont_re = re.compile('^$|^ (.*)$')
    self.any_line_re = re.compile('^(.*)$')

    if 'frames' in self.process.trace:
      self.process.acquire_object(self, 'INPUT FRAME['+str(depth)+']='+src.get_source_name())
    self.post_methods()

  def __del__(self):
    if 'frames' in self.process.trace:
      self.process.release_object(self)

  def get_input_frame(self): return self

#line 140 "input_frame.ipk"
  def post_methods(self):
    # input frame methods
    self.userdict.update(self.process.global_frame.__dict__)
    method_names = self.__class__.__dict__.keys()
    is_begin_or_end_method = lambda x: x[:3]=='end' or x[:5]=='begin'
    method_names = filter(is_begin_or_end_method, method_names)
    method_names = method_names + [
      'head','heading','push_head','pop_head','set_head',
      'line_break','page_break',
      'set_warning_character',
      'doc','p','eop','cite_url',
      'data_output','c_output','cpp_output',
      'python_output','perl_output',
      'interscript_output',
      'tangler',
      'push','pop','select','comment','resume_code',
      'tangler_push','tangler_pop','tangler_set', # temporarily!
      'get_tangler',
      'untangle',
      'weave','weave_line','tangle',
      'print_identifier_cross_reference',
      'print_contents',
      'print_file_list',
      'print_source_list',
      'print_include_list',
      'print_class_reference',
      'print_file_status',
      'get_weaver',
      'raw_if','enable','enable_if','disable',
      'get_input_frame',
      'table_row', 'table_rule',
      'begin_table_row','end_table_row',
      'begin_table_cell','end_table_cell',
      'item',
      'include_file','include_source',
      'include_code','insert_code','display_code',
      'sink_verbatim','expand','define',
      'include_html','html',
      'capture_output','print_output',
      'capture_python_output','print_python_output',
      'print_python_test_output',
      'set_weaver','get_weaver', 'push_weaver','pop_weaver',
      'get_attribute',
      'interscript_from_options',
      'test_interscript',
      'python','test_python',
      'register_test','set_test_result',
      'set_anchor','ref_anchor',
      'post_notice',
      'skip_upto','skip_upto_if',
      'set_encoding','get_encoding'
      ]
    for m in method_names:
      exec 'self.userdict[m]=self.'+m

    # pass frame methods
    method_names = [
      'get_pass_frame'
    ]
    for m in method_names:
      exec 'self.userdict[m]=self.pass_frame.'+m

    # processs frame methods
    method_names = ['get_process_frame']
    for m in method_names:
      exec 'self.userdict[m]=self.process.'+m

    #master frame methods
    method_names = [
      'get_master_frame',
      'set_title', 'get_title',
      'add_author',
      'set_native_language','get_native_language',
      'set_document_data', 'get_document_data']
    for m in method_names:
      exec 'self.userdict[m]=self.master.'+m

    #functions (non methods)
    # NOTE: most functions are made available thru the global frame!
    function_names = []
    for f in function_names:
      exec 'self.userdict[f]='+f

#line 226 "input_frame.ipk"
  def close(self):
    if 'frames' in self.process.trace:
      print 'closing frame',self.source.name
    self.userdict.clear()
    del self.userdict
    del self.current_tangler
    del self.current_weaver
    del self.reg_list
    while self.current_tangler_stack: del self.current_tangler_stack[-1]
    while self.current_weaver_stack: del self.current_weaver_stack[-1]

#line 239 "input_frame.ipk"
  def file_pass(self):
    while 1:
      try:
        file,count,line = self.readline()

        self.echo = 'input' in self.process.trace
        if self.echo:
          print '%s %6s: %s' % (file,count,line)
        for r in self.reg_list:
          match = r[0].match(line)
          if match:
            r[1](match,file,count,self.userdict)
            break
      except eoi:
        if 'frames' in self.process.trace:
          print 'EOI detected'
        if self.current_tangler:
          self.select(None)
        self.close()
        return
      except KeyboardInterrupt:
        print '!!!!!!!!! KEYBOARD INTERRUPT !!!!!!!!!'
        self.process.update_files = 0
        self.close()
        raise KeyboardInterrupt
      except process_fault,value:
        print '!!!!!!!!! PROCESS FAULT ',value,' !!!!!!!!!'
        self.process.update_files = 0
        self.close()
        raise
      except SystemExit,value:
        print '!!!!!!!!! SYSTEM EXIT !!!!!!!!!'
        self.process.update_files = 0
        self.close()
        raise SystemExit,value
      except:
        print '!!!!!!!!! PROGRAM ERROR !!!!!!!!!'
        traceback.print_exc()
        self.process.update_files = 0
        self.close()
        sys.exit(1)

#line 288 "input_frame.ipk"
  def interscript_from_options(self,*args):
    from interscript  import run_from_options
    svdin  = sys.stdin
    try:
      try:
        run_from_options(args)
      except KeyboardInterrupt: raise
      except SystemExit: raise
      except:
        print 'Error running embedded interscript from options'
        print 'options were', args
        traceback.print_exc()
    finally:
      sys.stdin  = svdin

  # Note: this routine is ONLY useful for testing interscript itself,
  # because it always puts the test code into the interscript directory!
  # This needs to be fixed!!!

  def test_interscript(self, description, source_terminator, *args, **kwds):
    testno = self.register_test(description, 'interscript')
    testlabel = 'test_'+str(testno)
    self.set_anchor(testlabel)
    self.current_weaver.writeline(
      'On-the-fly interscript for test '+str(testno)+' follows.')
    source_origin_line = self.original_count
    source_origin_file = self.original_filename
    test_code = self.collect_lines_upto(source_terminator)
    self.current_weaver.script_head('interscript',source_origin_file)
    for i in range(len(test_code)):
      self.current_weaver.echotangle(source_origin_line+i+1,test_code[i])
    self.current_weaver.script_foot('interscript',source_origin_file)

    try:
      os.mkdir('interscript/tests')
    except:
      pass
    our_source_filename = 'interscript/tests/test_'+str(testno)+'.tpk'
    f = open(our_source_filename,'w')
    f.write(string.join(test_code,'\n')+'\n')
    f.close()

    logfile='interscript/tests/output/test_'+str(testno)+'.log'

    kargs =  []
    for key in kwds.keys():
      if key not in ['description','source_terminator']:
        kargs.append('--' + key + '=' + repr(kwds[key]))

    newargs = args + tuple(kargs) + (
      '--weaver=html',
      '--weaver-prefix=interscript/tests/output/',
      '--new-logfile='+logfile,
      '--title=Test '+str(testno)+': '+description,
      our_source_filename)
    apply(self.interscript_from_options, newargs)
    self.set_test_result(testno,'inspect')
    self.current_weaver.doc()
    self.current_weaver.writeline('Test output at')
    self.current_weaver.cite_url('../tests/output/test_'+str(testno)+'.html')
    self.current_weaver.writeline('. Logfile at')
    self.current_weaver.cite_url('../tests/output/test_'+str(testno)+'.log')
    self.current_weaver.writeline('.')
    self.current_weaver.par()

#line 362 "input_frame.ipk"
  def get_attribute(self,name,default=None):
    if self.userdict.has_key(name):
      return self.userdict[name]
    else:
      return default

#line 380 "input_frame.ipk"
  def begin(self):
    ho = self.head_offset
    self.select(None)
    inpt = input_frame(
      self.pass_frame,
      self.source,
      [],
      self.current_weaver,
      self.userdict.copy(),
      self.depth)
    inpt.head_offset = ho
    inpt.set_warning_character(python=self.python_warn)
    inpt.file_pass()

  def end(self):
    self.select(None)
    raise eoi

#line 452 "input_frame.ipk"
  def include_file(self,name,encoding=None):
    if 'input' in self.process.trace:
      print 'input from',name
    file_signature = (self.depth+1,'interscript',name)
    if file_signature in self.pass_frame.skiplist:
      print 'SKIPPING INCLUDE FILE',file_signature
      i = 0
      t = self.master.src_tree
      n = len(t)
      while i<n:
        if file_signature == tuple(t[i][0:3]): break
        i = i + 1
      if i == n:
        print 'COULD NOT FIND SKIP FILE',file_signature,'in',t
      else:
        self.pass_frame.include_files.append(file_signature)
        i = i + 1
        lev = file_signature[0]
        while i<n:
          if t[i][0] >= lev: break
          print 'INSERTING',t[i][2],'into include file list (cheating)'
          self.pass_frame.include_files.append(tuple(t[i][0:3]))
          i = i + 1
    else:
      self.pass_frame.include_files.append(file_signature)
      if encoding is None:
        encoding = self.source.encoding_name
      self.include_source(named_file_source(
        self.pass_frame,name, self.source.directory, encoding=encoding))

  def include_source(self,source):
    self.select(None)
    ho = self.head_offset
    inpt = input_frame(
      self.pass_frame,
      source,
      [],
      self.current_weaver,
      self.userdict.copy(),
      self.depth+1)
    inpt.head_offset = ho
    inpt.set_warning_character(python='@')
    inpt.file_pass()
    self.current_weaver.set_original_filename (self.original_filename)
#line 499 "input_frame.ipk"
  def set_encoding(self, encoding):
    self.source.set_encoding(encoding)
  def get_encoding(self): return self.source.get_encoding()

#line 527 "input_frame.ipk"
  def insert_code(self,name):
    ifdata = (self.depth+1,'code: '+self.current_tangler.language,name)
    self.pass_frame.include_files.append(ifdata)
    r = []
    source = named_file_source(self.pass_frame,name, self.source.directory)
    inpt = input_frame(
      self.pass_frame,
      source,
      r,
      self.current_weaver,
      self.userdict.copy(),
      self.depth+1)
    r.append([inpt.any_line_re, inpt.do_web])
    inpt.select(self.current_tangler)
    inpt.file_pass()

  def include_code(self,name,current_tangler):
    ifdata = (self.depth+1,'code: '+current_tangler.language,name)
    self.pass_frame.include_files.append(ifdata)
    r = []
    source = named_file_source(
      self.pass_frame,
      name,
      self.source.directory)
    inpt = input_frame(
      self.pass_frame,
      source,
      r,
      self.current_weaver,
      self.userdict.copy(),
      self.depth+1)
    r.append([inpt.any_line_re, inpt.do_web])
    inpt.select(current_tangler)
    inpt.file_pass()

  def sink_verbatim(self,filename):
    self.current_weaver.label_chunk(filename)
    source = named_file_source(
        self.pass_frame,
        filename,
        self.source.directory)
    data = source.readlines()
    self.current_tangler.sink.writelines(data)

  def define(self, macroname, language='data'):
    self.select(self.output(cache_sink(macroname, self.master), language))

  def expand(self,macroname):
    self.current_weaver.label_chunk(macroname)
    source = cache_source(macroname, self.master)
    data = source.readlines()
    self.current_tangler.sink.writelines(data)

#line 601 "input_frame.ipk"

#line 618 "input_frame.ipk"
  def include_html(source):
    self.select(None)
    r = []
    self.pass_frame.include_files.append((self.depth+1,'html: '+self.current_tangler.language,name))
    inpt = input_frame(
      self.pass_frame,
      source,
      r,
      self.current_weaver,
      self.userdict.copy(),
      self.depth+1)
    inpt.html_parser = sgml_wrapper(html_filter(inpt))
    r.append((inpt.any_line_re,inpt.do_html))
    inpt.file_pass()

  def html(self):
    self.select(None)
    r = []
    inpt = input_frame(
      self.pass_frame,
      self.source,
      r,
      self.current_weaver,
      self.userdict.copy(),
      self.depth)
    inpt.html_parser = sgml_wrapper(html_filter(inpt))
    r.append((inpt.any_line_re,inpt.do_html))
    inpt.file_pass()



#line 651 "input_frame.ipk"
  def get_weaver(self):
    return self.current_weaver

  def set_weaver(self,w):
    tmp = self.current_weaver
    self.current_weaver = w
    return tmp

  def push_weaver(self,w):
    self.current_weaver_stack.append(self.current_weaver)
    self.current_weaver = w

  def pop_weaver(self):
    self.current_weaver = self.current_weaver_stack[-1]
    del self.current_weaver_stack[-1]

  def raw_if(self,tag):
    self.current_weaver.raw_if(tag)

  def enable_if(self,tag):
    self.current_weaver.enable_if(tag)

  def enable(self):
    self.current_weaver.enable()

  def disable(self):
    self.current_weaver.disable()

#line 681 "input_frame.ipk"
  def set_anchor(self,label):
    if self.current_tangler:
      self.current_tangler.weaver.set_anchor(label)
    else:
      self.current_weaver.set_anchor(label)

  def ref_anchor(self,label):
    self.current_weaver.ref_anchor(label)

#line 692 "input_frame.ipk"
  def set_warning_character(self,python=None):
    res = self.make_parse_tab(pywarn=python)
    res = compile_parse_tab(res)
    self.reg_list = res
    self.python_warn = python

  def normal_line(self,data,file,count):
    weaver = self.get_weaver()
    if self.current_tangler:
      self.current_tangler.writeline(data,file,count)
    else:
      weaver.writeline(data)

#line 709 "input_frame.ipk"
  def enqueue_input(self,file, count, line):
    self.read_buffer.append((file,count,line))

  def dequeue_input(self):
    data = self.read_buffer[0]
    del self.read_buffer[0]
    return data

  # This is the interscript version of a #line directive
  def line(self, number, filename):
    self.inpt.original_file = filename
    self.inpt.line_offset = number - inpt.src.get_lines_read()

  def readline(self):
    while 1:
      if self.read_buffer:
        return self.dequeue_input()
      try:
        line = self.source.readline()
        self.real_filename = self.source.get_source_name()
        self.real_count = self.source.get_lines_read()
        self.original_count = self.real_count + self.line_offset
        line = string.rstrip(line)
        self.line = string.expandtabs(line,self.tabwidth)
        return (self.original_filename,self.original_count,self.line)
      except KeyboardInterrupt:
        # should inhibit output for process, not globally
        self.process.update_files = 0
        raise KeyboardInterrupt
      except eof:
        if 'input' in self.process.trace:
          print 'readline: EOF'
        self.line = None
        raise eoi
      else:
        print 'program error in readline:',sys.exc_info()
        self.process.update_files = 0

#line 767 "input_frame.ipk"
  def untangle(self,name):
    if not self.current_tangler:
      raise 'untangle without active tangler'
    f = open(name)
    data = f.readlines()
    f.close()
    self.current_tangler.sink.writeline('@select(output("'+name+'"))')
    for line in data:
      l = string.rstrip(line)
      if len(l):
        if l[0]=='@': l = '@'+l
      self.inpt.tangler.sink.writeline(l)
    self.current_tangler.sink.writeline('@select(None)')
    self.current_tangler.weaver.begin_small()
    self.current_tangler.weaver.writeline('Included '+name+', '+str(len(data))+' lines.')
    self.current_tangler.weaver.end_small()
    self.current_tangler.weaver.line_break()

#line 812 "input_frame.ipk"
# regexp's for the main functions

  def make_parse_tab(self, pywarn = None):
    res = []
    if pywarn:
      res = res + [
        ['^'+pywarn+'('+pywarn+')(.*)$',self.do_quote_at],
        ['^'+pywarn+'(.*[-+*/%:,\\\\([{]) *(#.*)?$', self.do_exec_suite],
        ['^'+pywarn+'(.*)$',self.do_exec_line]
        ]


    res = res + [
      ['^(.*)$',self.do_web]
      ]
    return res

#line 839 "input_frame.ipk"
  def collect_stuff(self,prefix, cont_re, echo):
    saved = prefix
    try:
      file2,count2,line = self.readline()
      match = cont_re.match(line)
      while match:
        if echo:
          print '%s %6s: %s' % (file2,count2,line)
        body = match.group(1)
        if not body: body = ''
        saved = saved+'\n'+body
        file2,count2,line = self.readline()
        match = cont_re.match(line)
      self.enqueue_input(file2,count2,line)
    except eoi:
      pass
    saved = saved + '\n'
    return saved

  def collect_lines_upto(self,terminal, keep=0):
    term_re = re.compile('^'+terminal+'$')
    saved = []
    file,count,line = self.readline()
    match = term_re.match(line)
    while not match:
      saved.append(line)
      file,count,line = self.readline()
      match = term_re.match(line)
    return saved

  def skip_upto(self,terminal):
    term_re = re.compile('^'+terminal+'$')
    file,count,line = self.readline()
    match = term_re.match(line)
    while not match:
      file,count,line = self.readline()
      match = term_re.match(line)

  def skip_upto_if(self,terminal,condition):
    if condition: self.skip_upto(terminal)

  def collect_upto(self,terminal, keep=0):
    return string.join(self.collect_lines_upto(terminal,keep), '\n')+'\n'

#line 885 "input_frame.ipk"
  def python(self, terminal, keep=0):
    file = self.original_filename
    count = self.original_count
    data = self.collect_upto(terminal)
    self.process.py_exec(data,file,count,self.userdict)

#line 903 "input_frame.ipk"
  def print_diff_table(self, comparison,
    actual_heading='Actual', expected_heading='Expected',
    ok_message='Data compared equal.',
    diff_message='Differential follows.'):

    equal = len(comparison) == 0
    our_weaver = self.get_weaver()
    if not equal:
      if diff_message:
        our_weaver.writeline(diff_message)
      our_weaver.begin_table('Actual','Expected', CLASS='DIFF')
      for section in comparison:
        left = section[0][1:]
        right = section[1][1:]
        left = string.join(left,'\n')
        right = string.join(right,'\n')
        our_weaver.table_row([left, right])
      our_weaver.end_table()
    else:
      if ok_message:
        our_weaver.writeline(ok_message)

#line 927 "input_frame.ipk"
  def register_test(self, description, kind):
    testno = self.pass_frame.get_new_test_number()
    testlabel = 'test_'+str(testno)
    self.pass_frame.tests[testno]=\
      [description,testlabel,kind,'Aborted']
    return testno

  def set_test_result(self, testno, result):
    self.pass_frame.tests[testno][3]=result

#line 939 "input_frame.ipk"
  def test_python(self,
    hlevel=None,
    descr=None,
    source_filename=None,
    source_terminator=None,
    expect_filename=None,
    expect_terminator=None,
    diff_context=0):

    testno = self.pass_frame.get_new_test_number()
    testlabel = 'test_'+str(testno)
    test_record = self.pass_frame.tests[testno]=\
      [descr,testlabel,'python','Aborted']
    expect = expect_filename or expect_terminator

    # print heading
    if hlevel: our_hlevel = hlevel
    else: our_hlevel = self.last_head+1
    if descr == None: descr = 'Test'
    self.head(our_hlevel,'Test '+str(testno)+': '+descr)
    self.set_anchor(testlabel)

    our_weaver = self.get_weaver()

    if source_terminator:
      our_weaver.writeline('On-the-fly python test script follows.')
      source_origin_line = self.original_count
      source_origin_file = self.original_filename
      test_code = self.collect_lines_upto(source_terminator)
      our_weaver.script_head('python',source_origin_file)
      for i in range(len(test_code)):
        our_weaver.echotangle(source_origin_line+i+1,test_code[i])
      our_weaver.script_foot('python',source_origin_file)
    elif source_filename:
      our_weaver.writeline('Python test script from file '+source_filename+'.')

    if expect_terminator:
      expected_origin_line = self.original_count
      expected_origin_file = self.original_filename
      expected_output = self.collect_lines_upto(expect_terminator)
    elif expect_filename:
      # FIX to make document relative
      our_weaver.writeline('Expected output from file '+expected_filename+'.')
      expected_lines = loadfile(expect_filename)

    # execute the test code

    if source_filename:
      our_source_filename = source_filename
      description = None
    else:
      our_source_filebase = tempfile.mktemp()
      our_source_filename = our_source_filebase + '_test.py'
      f = open(our_source_filename,'w')
      f.write(string.join(test_code,'\n')+'\n')
      f.close()
      description = 'python <<temporary>>'
    our_weaver.writeline('Actual output follows.')

    status, actual_output = self.print_python_output(
      our_source_filename,
      description)
    cmd_ok = status == 0

    # delete the file if it was created anonymously
    if not source_filename:
      os.remove(our_source_filename)

    if expect:
      try:
        diff_lines = interscript.utilities.diff.diff_lines
        comparison = diff_lines(actual_output, expected_output, context=diff_context)
        equal = len(comparison)==0
        self.pass_frame.tests[testno][2]= 'diff'
        self.pass_frame.tests[testno][3]= ('Fail','Ok')[equal]
        if not equal:
          our_weaver.writeline('On-the-fly expected output follows.')
          our_weaver.expected_head(expected_origin_file)
          for i in range(len(expected_output)):
            our_weaver.echotangle(expected_origin_line+i+1,expected_output[i])
          our_weaver.expected_foot(expected_origin_file)
          self.print_diff_table(comparison)
      except ImportError:
        our_weaver.writeline('Unable to import diff to perform comparison.')
      except KeyboardInterrupt: raise
      except SystemExit: raise
      except:
        traceback.print_exc()
    else:
      self.pass_frame.tests[testno][3]='Inspect'

#line 1049 "input_frame.ipk"
  def do_exec_line(self,match, file,count,dict):
    self.process.py_exec(match.group(1),file,count,dict)

#line 1054 "input_frame.ipk"
  def do_exec_suite(self,match,file,count,dict):
    saved = self.collect_stuff(match.group(1), self.cont_re, self.echo)
    self.process.py_exec(saved,file,count,dict)

#line 1060 "input_frame.ipk"
  def do_web(self,match,file,count,dict):
    self.normal_line(match.group(1),file,count)

#line 1065 "input_frame.ipk"
  def do_quote_at(self,match,file,count,dict):
    self.normal_line(match.group(1)+match.group(2),file,count)

#line 1070 "input_frame.ipk"
  def do_html(self,match,file,count,dict):
    self.html_parser.writeline(match.group(1),file,count)

#line 1083 "input_frame.ipk"
  def tangler_push(self,f):
    self.current_tangler_stack.append(self.current_tangler)
    self.current_tangler = f

  def tangler_pop(self):
    self.current_tangler = self.current_tangler_stack[-1]
    del self.current_tangler_stack[-1]

  def tangler_set(self,f):
    self.current_tangler = f

  def get_tangler(self):
    return self.current_tangler

#line 1103 "input_frame.ipk"
  def data_output(self,f): return self.tangler(f,'data')
  def c_output(self,f): return self.tangler(f,'c')
  def cpp_output(self,f): return self.tangler(f,'cpp')
  def python_output(self,f): return self.tangler(f,'python')
  def perl_output(self,f): return self.tangler(f,'perl')

  # temporarily, we'll use a data tangler
  def interscript_output(self,f):
    filename = self.master.tangler_directory+f
    sink = named_file_sink(self.pass_frame,filename,self.master.tangler_prefix)
    return self.tangler(sink,'data')

  def tangler(self,device, language=deduce, *args, **kwds):
    if has_protocol(device, 'filename'):
      filename = self.master.tangler_directory+str(device)
      sink = named_file_sink(
        self.pass_frame,
        filename,
        self.master.tangler_prefix)
    elif has_protocol(device, 'sink'):
      sink = device
    else: raise TypeError,'tangler device argument must be string or sink'

    if language is None: language = 'data'
    if language is deduce:
      try:
        splitup = string.split(sink.name,'.')
        if len(splitup)>1:
          extension = splitup[-1]
          language = extension_table [extension]
        else: language = 'data'
      except KeyError: language = 'data'
      except IndexError: language = 'data'
    language = string.lower(language)
    language = string.replace(language,'++','pp') # C++ hack
    language = string.replace(language,'-','_') # obj-C etc
    cmd = 'from interscript.tanglers.'+language+' import '+language+'_tangler\n'
    cmd = cmd + 't=apply('+language+'_tangler,(sink,self.current_weaver)+args,kwds)'
    try:
      exec cmd
    except:
      print 'Unable to load',language,'tangler: using data'
      t=data_tangler(sink,self.current_weaver)
    return t

#line 1199 "input_frame.ipk"
  def push(self,f):
    if self.current_tangler: self.code_foot()
    self.tangler_push(f)
    if self.current_tangler: self.code_head()

  def pop(self):
    if self.current_tangler: self.code_foot()
    self.tangler_pop()
    if self.current_tangler: self.code_head()

#line 1210 "input_frame.ipk"
  def select(self, *args, **kwds):
    for arg in args:
      self.select1(arg)
    if kwds.has_key('tangler'):
      self.select_tangler(kwds['tangler'])
    if kwds.has_key('weaver'):
      self.set_weaver(kwds['weaver'])

  def select1(self, arg):
    if has_protocol(arg,'tangler'):
      self.select_tangler(arg)
    elif has_protocol(arg, 'weaver'):
      self.set_weaver(arg)
    elif arg is None:
      self.select_tangler(None)
    else:
      pass #permissive

  def select_tangler(self,f):
    if self.current_tangler: self.code_foot()
    self.tangler_set(f)
    if self.current_tangler: self.code_head()

  def code_head(self):
    dst_filename = self.current_tangler.sink.name
    dst_lineno = self.current_tangler.sink.lines_written
    src_filename = self.original_filename
    src_lineno = self.original_count

    index = self.pass_frame.section_index
    list = index.get(dst_filename, [])
    list.append((dst_lineno, src_filename, src_lineno))
    index[dst_filename]=list
    secno = len(list)
    self.current_weaver.code_head(self.current_tangler, secno)

  def code_foot(self):
    dst_filename = self.current_tangler.sink.name
    index = self.pass_frame.section_index
    list = index.get(dst_filename, [])
    secno = len(list)
    self.current_weaver.code_foot(self.current_tangler, secno)

  def begin_comments(self):
    if self.current_tangler:
      self.current_tangler_push(self.current_tangler.get_comment_tangler())
    else:
      self.current_tangler_push(None)

  def end_comments(self):
    self.current_tangler_pop()

  def resume_code(self):
    self.current_tangler_pop()

  def comment(self,v):
    self.get_weaver().write_comment(v)

  def begin_string(self,eol = ' ', width = 0):
    if self.current_tangler:
      self.current_tangler_push(self.current_tangler.get_string_tangler(eol,width))
    else:
      self.current_tangler_push(None)

  def end_string(self):
    tangler_pop()

  def weave(self,s):
    weaver = self.get_weaver()
    weaver.write(s)

  def weave_line(self,s):
    weaver = self.get_weaver()
    weaver.writeline(s)

  def tangle(self,s, inhibit_sref=0):
    if self.current_tangler:
      line = self.original_count
      file = self.original_filename
      self.current_tangler.writeline(s,file,line,inhibit_sref)
    else:
      print "tangle: No tangler for",s

#line 1296 "input_frame.ipk"
  def print_contents(self,*args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_contents, args, kwds)

  def print_file_list(self,*args,**kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_file_list, args, kwds)

  def print_file_status(self,*args,**kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_file_status, args, kwds)

  def print_source_list(self, *args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_source_list, args, kwds)

  def print_include_list(self, *args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_include_list, args, kwds)

  def macro(self,name):
    self.select(None)
    weaver = self.get_weaver()
    return data_tangler(memory(name),weaver)

  def print_identifier_cross_reference(self, *args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.identifier_reference, args, kwds)

  def print_class_reference(self, *args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.class_reference, args, kwds)

#line 1339 "input_frame.ipk"
  def capture_output(self,command):
    commands = self.global_frame.commands
    status, output = commands.getstatusoutput(command)
    data = string.split(output,'\n')
    return (status,data)

  def print_output(self,command,description=None):
    status, data = self.capture_output(command)
    weaver = self.get_weaver()
    if description: cmd = description
    else: cmd = command
    weaver.test_output_head(cmd, status)
    for i in range(len(data)):
      line = data[i]
      l = string.rstrip(line)
      weaver.echotangle(i+1,l)
    weaver.test_output_foot(cmd, status)
    return (status, data)

  def capture_python_output(self,script):
    return self.capture_output('"'+sys.executable+'" '+script)

  def print_python_output(self,script, description=None):
    return self.print_output(
      '"'+sys.executable+'" '+script,
      description)

  def print_python_test_output(self,script, descr):
    testno = self.pass_frame.get_new_test_number()
    testlabel = 'test_'+str(testno)
    self.pass_frame.tests[testno]=[descr,testlabel,'python','Unknown']
    self.set_anchor(testlabel)
    return self.print_python_output(script,descr)

#line 1381 "input_frame.ipk"
  def head(self, level, text, **kwds):
    level = int(level)
    level = level + self.head_offset
    self.last_head = level
    if 'headings' in self.process.trace:
      print ('  '*(level-1))+'"'+text+'"'
    self.pass_frame.toc.append((level,text, kwds))
    if self.current_tangler: self.code_foot()
    self.tangler_set(None)
    apply(add_translation,(text,),kwds.get('translations',{}))
    apply(self.current_weaver.head,(level,text),kwds)

  # like heading, but to be used in code as well:
  # doesn't switch to document mode, doesn't do
  # code headings and footings.
  # deprecated form client interface, but required for perl tangler

  def heading(self, level, text, **kwds):
    level = int(level)
    level = level + self.head_offset
    self.last_head = level
    if 'headings' in self.process.trace:
      print ('  '*(level-1))+'"'+text+'"'
    self.pass_frame.toc.append((level,text, kwds))
    apply(self.current_weaver.head,(level,text),kwds)

  def push_head(self, amt=1):
    self.head_offset = self.head_offset + amt

  def pop_head(self, amt=1):
    self.push_head(-amt)

  def set_head(self, amt=None):
    if amt != None:
      self.head_offset = amt - 1
    else:
      self.head_offset = self.last_head - 1

#line 1421 "input_frame.ipk"
  def doc(self):
    if self.current_tangler: self.code_foot()
    self.tangler_set(None)

  def p(self): # end a paragraph and start a new one
    self.current_weaver.par()

  def eop(self): # end a paragraph without starting a new one
    self.current_weaver.eop()

  def line_break(self): self.current_weaver.line_break()
  def page_break(self): self.current_weaver.page_break()

#line 1436 "input_frame.ipk"
  def cite_url(self, url):
    self.current_weaver.cite_url(url)

#line 1441 "input_frame.ipk"
  def begin_table(self, *headings, **kwds):
    apply(self.get_weaver().begin_table, headings, kwds)

  def table_row(self, *data):
    self.current_weaver.table_row(data)

  def end_table(self):
    self.current_weaver.end_table()

  def table_rule(self):
    self.current_weaver.table_rule()

  def begin_table_row(self):
    self.current_weaver.begin_table_row()

  def end_table_row(self):
    self.current_weaver.end_table_row()

  def begin_table_cell(self):
    self.current_weaver.begin_table_cell()

  def end_table_cell(self):
    self.current_weaver.end_table_cell()

#line 1467 "input_frame.ipk"
  def begin_list(self, style):
    self.current_weaver.begin_list(style)

  def end_list(self):
    self.current_weaver.end_list()

  def item(self,*args, **kwds):
    apply(self.current_weaver.item, args, kwds)

  def begin_numbered_list(self, start=1):
    self.current_weaver.begin_numbered_list(start)

  def end_numbered_list(self):
    self.current_weaver.end_numbered_list()

  def begin_numbered_list_item(self):
    self.current_weaver.begin_numbered_list_item()

  def end_numbered_list_item(self):
    self.current_weaver.end_numbered_list_item()

  def begin_bullet_list(self):
    self.current_weaver.begin_bullet_list()

  def end_bullet_list(self):
    self.current_weaver.end_bullet_list()

  def begin_bullet_list_item(self):
    self.current_weaver.begin_bullet_list_item()

  def end_bullet_list_item(self):
    self.current_weaver.end_bullet_list_item()

  def begin_keyed_list(self):
    self.current_weaver.begin_keyed_list()

  def end_keyed_list(self):
    self.current_weaver.end_keyed_list()

  def begin_keyed_list_item(self, key):
    self.current_weaver.begin_keyed_list_item(key)

  def end_keyed_list_item(self):
    self.current_weaver.end_keyed_list_item()

#line 1514 "input_frame.ipk"
  def begin_emphasize(self):
    self.current_weaver.begin_emphasize()

  def end_emphasize(self):
    self.current_weaver.end_emphasize()

  def begin_strong(self):
    self.current_weaver.begin_strong()

  def end_strong(self):
    self.current_weaver.end_strong()

  def begin_italic(self):
    self.current_weaver.begin_italic()

  def end_italic(self):
    self.current_weaver.end_italic()

  def begin_bold(self):
    self.current_weaver.begin_bold()

  def end_bold(self):
    self.current_weaver.end_bold()

  def begin_big(self):
    self.current_weaver.begin_big()

  def end_big(self):
    self.current_weaver.end_big()

  def begin_small(self):
    self.current_weaver.begin_small()

  def end_small(self):
    self.current_weaver.end_small()

  def begin_code(self):
    self.current_weaver.begin_code()

  def end_code(self):
    self.current_weaver.end_code()

#line 1558 "input_frame.ipk"
  def begin_displayed_code(self):
    self.current_weaver.begin_displayed_code()

  def end_displayed_code(self):
    self.current_weaver.end_displayed_code()

  # this command is used to print out a code file 'verbatim'
  # without line numbers!
  def display_code(self,name,kind='code'):
    self.pass_frame.include_files.append((self.depth+1,kind,name))
    self.begin_displayed_code()
    filename = parse_source_filename(name, self.source.directory)[3]
    f = open(filename)
    data = f.readlines()
    f.close()
    weaver = self.get_weaver()
    for line in data:
      l = string.rstrip(line)
      weaver.writeline(l)
    self.end_displayed_code()

#line 1582 "input_frame.ipk"
  def post_notice(self, key, value):
    self.master.noticedict[key]=value
#line 1585 "input_frame.ipk"

