#line 21 "felix_func.ipk"
from interscript.felix.model.basecat import category

class function:
  def __init__(self, *args):
    self.funcs = args
    self.normalise()

  def __call__(self, arg):
    for f in self.funcs:
      #print 'calling',f,'arg',arg
      arg = f(arg)
    return arg

  def __and__(self,func):
    return apply(function,self.funcs+func.funcs).normalise()

  def __mul__(self, func):
    return function(function_product(self,func))

  def __add__(self, func):
    return function(function_sum(self,func))

  def normalise(self):
    if self.funcs:
      first = self.funcs[0]
      if isinstance(first, constant):
        self.funcs = (constant(self(None)),)
    return self

#line 52 "felix_func.ipk"
class identity(function):
  def __call__(self, arg): return arg
  def __and__(self,func): return func



#line 66 "felix_func.ipk"
class input_adapter:
  def __init__(self, func):
    self.func = func

  def __call__(self, arg):
    return apply(self.func, arg[0], arg[1])

#line 76 "felix_func.ipk"
class output_adapter:
  def __init__(self, func):
    self.func = func

  def __call__(self, arg):
    return ((self.func(arg),), {})

#line 89 "felix_func.ipk"
class constant(function):
  def __init__(self, value): self.value = value
  def __call__(self, arg): return self.value
  def is_equivalent(self, other): return self.value == other.value

#line 97 "felix_func.ipk"
class cat_function(category):
  def is_arrow(self, f): return isinstance(f, function)
  def is_object(self, f): return isinstance(f, identity)
  def compose(self, left, right): return left&right
  def domain(self, arrow): return identity()
  def codomain(self, arrow): return identity()


#line 109 "felix_func.ipk"
class function_product:
  def __init__(self, *funcs):
    self.funcs = funcs
  def __call__(self, arg):
    #print 'calling product, arg=',arg
    result = []
    for i in range(len(self.funcs)):
      result.append(self.funcs[i](arg[i]))
    return tuple(result)

#line 123 "felix_func.ipk"
class function_sum:
  def __init__(self, *args):
    self.funcs = args
  def __call__(self, arg):
    #print 'function sum, arg=',arg
    return self.funcs[arg[0]](arg[1])

