#line 302 "utf8.ipk"
import string

def utf16(i):
  if i<0x10000:
    return chr(i>>8) + chr(i &0xff)
  else
    w1 = 0xD800 + ((i - 0x10000) >> 10)
    w2 = 0xDC00 + ((i - 0x10000) & 0x3FF)
    return\
      chr(w1>>8) + chr(w1 &0xff) +\
      chr(w2>>8) + chr(w2 &0xff)

def seq_to_utf16(a):
  s = ''
  for ch in a: s = s + utf16(ch)
  return s

# decoding
def parse_utf16(s, i):
  if s[0] < 0xDC or s[0] > 0xE0:
    return s[0] << 8 + s[1],2
  else:
    w1 = s[0] << 8 + s[1]
    w2 = s[2] << 8 + s[3]
    return 0x10000 + ((w1 - 0xD800) << 10) + w2 -0xDC00, 4

def utf16_to_array(s):
  n = len(s)
  i = 0
  m = 0
  while i < n:
    parse_utf8(s,i)
    m = m + 1
  a = array('H',(0,)*m)
  i = 0
  while i < n:
    a[i/4],i = parse_utf16(s,i)

def utf16_to_utf8(s):
  return seq_to_utf8(utf16_to_array(s))


