/* ================================================================ */
/*
File:   ConvertUTF7.h
Author: David B. Goldsmith
Copyright (C) 1994 Taligent, Inc. All rights reserved.
*/
/* ================================================================ */

/* ================================================================ */
/*      The following definitions are compiler-specific.
        I would use wchar_t for UCS2/UTF16, except that the C standard
        does not guarantee that it has at least 16 bits, so wchar_t is
        no more portable than unsigned short!
*/

typedef unsigned short  UCS2;

/* ================================================================ */
/*      Each of these routines converts the text between *sourceStart and
sourceEnd, putting the result into the buffer between *targetStart and
targetEnd. Note: the end pointers are *after* the last item: e.g.
*(sourceEnd - 1) is the last item.

        The return result indicates whether the conversion was successful,
and if not, whether the problem was in the source or target buffers.

        After the conversion, *sourceStart and *targetStart are both
updated to point to the end of last text successfully converted in
the respective buffers.

                In ConvertUCS2toUTF7, optional indicates whether UTF-7 optional
characters should be directly encoded, and verbose controls whether the
shift-out character, "-", is always emitted at the end of a shifted
sequence.
*/

typedef enum {
        ok,                             /* conversion successful */
        sourceCorrupt,          /* source contains invalid UTF-7 */
        targetExhausted         /* insuff. room in target for conversion */
} ConversionResult;

extern ConversionResult        ConvertUCS2toUTF7 (
                UCS2** sourceStart, UCS2* sourceEnd,
                char** targetStart, char* targetEnd,
                int optional, int verbose);

extern ConversionResult        ConvertUTF7toUCS2 (
                char** sourceStart, char* sourceEnd,
                UCS2** targetStart, UCS2* targetEnd);

/* ================================================================ */
