#line 76 "big5.ipk"
from array import array

lead_first = 0xA1
lead_last = 0xF9
trail_first1 = 0x41
trail_last1 = 0x7E
group1_width = trail_last1 - trail_first1 + 1
trail_first2 = 0xA1
trail_last2 = 0xFE
width = trail_last1 - trail_first1 + 1 + trail_last2 - trail_first2 + 1
big5size = (lead_last - lead_first + 1) * width



tou = array('H')
filename = 'interscript/encoding/big5.dat'
f = open(filename,'rb')
tou.fromfile(f,big5size)
f.close()

def big5_to_unicode(ch):
  hi = ch >> 8
  lo = ch & 0xFF
  if lead_first <= hi <= lead_last:
    if trail_first1 <= lo <= trail_last1:
      return tou[(hi-lead_first)*width+lo-trail_first1]
    elif trail_first2 <= lo <= trail_last2:
      return tou[(hi-lead_first)*width+lo-trail_first2+group1_width]
    else:
      return 0xFFFF
  else:
    return 0xFFFF

def big5_to_utf8(s):
  u = ''
  i = 0
  n = len(s)
  while 1:
    ch = s[i]
    i = i + 1
    ch = ch << 8 | s[i]
    u = u + utf8(big5_to_unicode(ch))
    i = i + 1
    if i==n: break
  return u

