#define BEGIN_METHOD(x) PyObject *x(PyObject *self, PyObject *args) {
#define BEGIN_CTOR(type,x) PyObject *x(PyObject *self, PyObject *args) {
#define END_METHOD }
#define RETURN_SELF Py_INCREF(self); return self; }
#define RETURN_NONE Py_INCREF(Py_None); return Py_None; }
#define RETURN_OBJECT(result) return (PyObject*)(result); }
#define RETURN_INT(result) return PyInt_FromLong(result); }
#define RETURN_DOUBLE(result) return PyFloat_FromDouble(result); }
#define BEGIN_METHOD_TABLE(x) static PyMethodDef x [] = {
#define END_METHOD_TABLE(x) {NULL, NULL, 0} };
#define METHOD_ENTRY(s,m,d)  {s, m, 1, d},
#define BEGIN_VIRTUAL_TABLE(x) PyTypeObject x = { PyObject_HEAD_INIT(&PyType_Type)
#define END_VIRTUAL_TABLE };


#define CALL(x) PyObject *x( PyObject *self, PyObject *args, PyObject *kwds) {
#define PRINT(x) int x( PyObject *self, FILE *fp, int flags) {
#define DEALLOC(x) void x( PyObject *self) {
#define GETATTR(x) PyObject * x( PyObject *self, char *name) {
#define SETATTR(x) int x( PyObject *self, char *name, PyObject *value) {
#define REPR(x) PyObject * x( PyObject *self ) {
#define STR(x) PyObject * x( PyObject *self ) {
#define END }
#define BEGIN_DOC(x) char *x =
#define END_DOC ;

#define UTILITY(x) x
#include <Python.h>

// iscrcopt module

  BEGIN_DOC(iscrcopt_module_doc)
    "The iscrcopt module provides some functions to speed up interscript\n"
    END_DOC

  // define the commands of a python module
    // get a type


      BEGIN_METHOD(cvt_code)
        char *s;
        char *p;
        char *q;
        char *r;
        char ch;
        int n;
        int m;
        int count;
        PyObject *pys;
        if (!PyArg_ParseTuple(args, "s#", &s, &n)) return NULL;
        count = 0;
        p = s;
        m = n;
        while(m--) {
          ch = *p++;
          switch(ch) {
            case '<':
            case '>': count+=3;
            default: count++;
          }
        }
        r = (char*)malloc(count);
        q = r;
        p = s;
        m = n;
        while(m--) {
          ch = *p++;
          switch(ch) {
            case '<':
              *q++ = '&';
              *q++ = 'l';
              *q++ = 't';
              *q++ = ';';
              break;
            case '>':
              *q++ = '&';
              *q++ = 'g';
              *q++ = 't';
              *q++ = ';';
              break;
            default: *q++=ch;
          }
        }
        pys = PyString_FromStringAndSize(r,n);
        free(r);
        RETURN_OBJECT(pys)

      BEGIN_METHOD(cvt_text)
        char *s;
        char *p;
        char *q;
        char *r;
        char ch;
        int n;
        int count;
        int m;
        PyObject *pys;
        if (!PyArg_ParseTuple(args, "s#", &s, &n)) return NULL;
        count = 0;
        p = s;
        m = n;
        while(m--) {
          ch = *p++;
          switch(ch) {
            case '&': ++count;
            case '<':
            case '>': count+=3;
            default: count++;
          }
        }
        r = (char*)malloc(count);
        q = r;
        p = s;
        m = n;
        while(m--) {
          ch = *p++;
          switch(ch) {
            case '<':
              *q++ = '&';
              *q++ = 'l';
              *q++ = 't';
              *q++ = ';';
              break;
            case '>':
              *q++ = '&';
              *q++ = 'g';
              *q++ = 't';
              *q++ = ';';
              break;
            case '&':
              *q++ = '&';
              *q++ = 'a';
              *q++ = 'm';
              *q++ = 'p';
              *q++ = ';';
              break;
            default: *q++=ch;
          }
        }
        pys = PyString_FromStringAndSize(r,n);
        free(r);
        RETURN_OBJECT(pys)


    // PyTcl module method table

      BEGIN_METHOD_TABLE(iscrcopt_moduleMethods)
        METHOD_ENTRY("cvt_code",cvt_code,
          "replaces < and > in a line with &lt; and &rt; respectively")
        METHOD_ENTRY("cvt_text",cvt_text,
          "replaces <, > and & in a line with &lt; &rt; and &amp; respectively")
        END_METHOD_TABLE(iscrcopt_moduleMethods)

  // utility to create a string valued attribute of a dictionary

    static void
    ins_string(PyObject *d, char *name, char *val) {
      PyObject *v = PyString_FromString(val);
      if(v) {
        PyDict_SetItemString(d, name, v);
        Py_DECREF(v);
      }
    }
  // PyTcl module initialisation routine

    BEGIN_DOC(iscrcopt_moduleDoc)
      "iscrcopt interscript speedups"
      END_DOC

    static void initialise(char *modname) {
      PyObject *m = Py_InitModule4(
        modname,
        iscrcopt_moduleMethods,
        iscrcopt_moduleDoc,
        NULL,
        PYTHON_API_VERSION);
      PyObject *d = PyModule_GetDict(m);

      PyDict_SetItemString(d, "__doc__", PyString_FromString(iscrcopt_moduleDoc));

      // check for an error
        if (PyErr_Occurred())
          Py_FatalError("Can't initialise module 'iscrcopt'");
    }

    void initiscrcopt(void) { initialise("iscrcopt"); }
