#line 155 "utf8.ipk"
from array import array

# encoding
def ucs2(i):
  return chr(i >> 8) + chr(i & 0xFF)

def seq_to_ucs2(a):
  s = ''
  for ch in a: s = s + ucs2(ch)
  return s

# decoding
def parse_ucs2(s, i):
  return ord(s[i]) << 8 + ord(s[i+1]), i+2

def ucs2_to_array(s):
  n = len(s)
  a = array('H',(0,)*n/2)
  i = 0
  while i < n:
    a[i/2],i = parse_ucs2(s,i)

def ucs2_to_utf8(s):
  return seq_to_utf8(ucs2_to_array(s))

