#line 68 "wansung.ipk"
from array import array

lead_first = 0x21
lead_last = 0x7D
trail_first = 0x21
trail_last = 0x7E
width = trail_last - trail_first + 1
kscsize = (lead_last - lead_first + 1) * width


tou = array('H')
filename = 'interscript/encoding/ksc5601-1987.dat'
f = open(filename,'rb')
tou.fromfile(f,kscsize)
f.close()

def ksc5601_1987_to_unicode(ch):
  hi = ch >> 8
  lo = ch & 0xFF
  if lead_first <= hi <= lead_last and trail_first <= lo <= trail_last:
    return tou[(hi-lead_first)*width+lo-trail_first]
  else:
    return 0xFFFF

def ksc5601_1987_to_utf8(s):
  u = ''
  i = 0
  n = len(s)
  while 1:
    ch = s[i]
    i = i + 1
    ch = ch << 8 | s[i]
    u = u + utf8(ksc5601_1987_to_unicode(ch))
    i = i + 1
    if i==n: break
  return u

