#line 105 "gb2312.ipk"
from array import array

firstval = 0x21
lastval = 0x7E
width = lastval - firstval + 1
gbsize = width * width

tou = array('H')
filename = 'interscript/encoding/gb2312.dat'
f = open(filename,'rb')
tou.fromfile(f,gbsize)
f.close()
del f

def gb2312_80_to_unicode(ch):
  hi = ch >> 8
  lo = ch & 0xFF
  if firstval <= hi <= lastval and firstval <= lo <= lastval:
    return tou[(hi-firstval)*width+lo-firstval]
  else:
    return 0xFFFF

def gb2312_80_to_utf8(s):
  u = ''
  i = 0
  n = len(s)
  while 1:
    ch = s[i]
    i = i + 1
    ch = ch << 8 | s[i]
    u = u + utf8(gb2312_80_to_unicode(ch))
    i = i + 1
    if i==n: break
  return u

