#line 129 "mxTools.pak"
class NotGiven: pass
__version__ = "0.9.1"
from interscript.core.protocols import has_protocol
#line 265 "mxTools.pak"
def napply(number_of_calls, function, args=(), kw = {}):
  alist = []
  for i in range(number_of_calls):
    alist.append(apply(function, args, kw))
  return tuple(alist)
#line 358 "mxTools.pak"
def mapply(callable_objects, args=(), kw={}):
  alist = []
  for callable in callable_objects:
    alist.append(apply(callable,args, kw))
  return tuple(alist)

#line 471 "mxTools.pak"
def method_mapply(objects, methodname, args=(), kw={}):
  alist = []
  for object in objects:
    alist.append(apply(getattr(object,methodname),args, kw))
  return tuple(alist)

#line 594 "mxTools.pak"
def trange(start=0, stop=NotGiven, step=1):
  if stop is NotGiven:
    stop = start
    start = 0
  return tuple(range(start, stop, step))

#line 673 "mxTools.pak"
def indices(object):
  return tuple(range(len(object)))

#line 714 "mxTools.pak"
def range_len(object):
  return range(len(object))

#line 753 "mxTools.pak"
def irange(object,indices = NotGiven):
  if indices is NotGiven: indices = trange(len(object))
  x = []
  for index in indices:
    x.append((index, object[index]))
  return tuple(x)

#line 849 "mxTools.pak"
def get(object,index, default = NotGiven):
  try:
    return object[index]
  except KeyboardInterrupt: raise
  except:
    if default is not NotGiven:
      return default
    else: raise

#line 887 "mxTools.pak"
def extract (object, indices, defaults = NotGiven):
  alist = []
  seq = 0
  for index in indices:
    try:
      alist.append(object[index])
    except KeyboardInterrupt: raise
    except:
      if defaults is not NotGiven:
        alist.append(defaults[seq])
      else:
        raise IndexError,"mxTools: extract: default not supplied"
    seq = seq + 1
  return alist

#line 988 "mxTools.pak"
def ifilter(condition, object, indices = NotGiven):
  if indices is NotGiven: indices = trange(len(object))
  alist = []
  for index in indices:
    value = object[index]
    if condition(value):
      alist.append((index,value))
  return alist

#line 1129 "mxTools.pak"
# this function should be called transpose :-)
def tuples(*sequence):
  if len(sequence) == 1: sequence = sequence[0]
  m = len(sequence[0])
  result = apply(map,(None,)+sequence)[:m]
  print 'tuples'+`sequence`+'='+`result`
  return result
#line 1227 "mxTools.pak"
# this function should also be called transpose :-)
def lists(*sequence):
  if len(sequence) == 1: sequence = sequence[0]
  m = len(sequence[0])
  alist = apply(map,(None,)+tuple(sequence))[:m]
  result = tuple(map(list, alist))
  #for i in range(len(alist)):
  #  alist[i]=list(alist[i])
  #result = tuple(alist)
  print 'lists'+`sequence`+'='+`result`
  return result

#line 1325 "mxTools.pak"
def _bool(x):
  if x: return 1
  else: return 0

def count(condition,sequence):
  x = 0
  for value in sequence:
    x = x + _bool(condition(value))
  return x

#line 1391 "mxTools.pak"
def exists(condition,sequence):
  return count(condition, sequence) != 0

#line 1453 "mxTools.pak"
def forall(condition,sequence):
  return count(condition, sequence) == len(sequence)

#line 1515 "mxTools.pak"
def index(condition,sequence):
  for i in range(len(sequence)):
    if condition(sequence[i]):
      return i
  raise ValueError
#line 1582 "mxTools.pak"
def sizeof(condition,sequence):
  raise 'We cannot get the sizeof an object in Python'

#line 1610 "mxTools.pak"
def findattr(object_list,attrname):
  for object in object_list:
    if hasattr(object, attrname):
      return getattr(object, attrname)
  raise AttributeError,attrname

#line 1663 "mxTools.pak"
def attrlist(object_list,attrname):
  alist = []
  for object in object_list:
    if hasattr(object, attrname):
      alist.append(getattr(object, attrname))
  return alist

#line 1725 "mxTools.pak"
def dict(items):
  adict = {}
  for key,value in items:
    adict[key] = value
  return adict

#line 1787 "mxTools.pak"
def setdict(sequence, value=None):
  adict = {}
  for key in sequence:
    adict[key] = value
  return adict

#line 1845 "mxTools.pak"
def invdict(dictionary):
  adict = {}
  for key in dictionary.keys():
    adict[dictionary[key]] = key
  return adict

# EXTENSION: proper inverse of dictionary,
# returns dictionary of lists
def proper_invdict(dictionary):
  adict = {}
  for key in dictionary.keys():
    value = dictionary[key]
    if not adict.has_key(value):
      adict[value]=[]
    adict[value].append(key)
  return adict

#line 1896 "mxTools.pak"
def reverse(sequence):
  alist = list(sequence)
  alist.reverse()
  if type(sequence) is type(()):
    return tuple(alist)
  return alist

#line 2036 "mxTools.pak"
def proper_acquire(object, name, functor='baseobj'):
  if hasattr(object, name):
    return getattr(object,name)
  return acquire(object, name, functor)

def acquire(object, name, functor='baseobj'):
  if not hasattr(object,functor):
    raise AttributeError,functor
  return proper_acquire(getattr(object, functor), name, functor)

#line 2290 "mxTools.pak"
class xmap:
  def __init__(self, func, *seqs):
    self.func = func
    self.seqs = seqs

  def __getslice__(self, start, end):
    result = []
    for i in range(start, end):
      result.append(self.__getitem__(i))
    return result

  def __getitem__(self, index):
    args = []
    for i in range(len(self.seqs)):
      args.append(self.seqs[i][index])
    return apply(self.func, tuple(args))

  def tolist(self):
    return apply(map,self.seqs)

try:
  from mxTools import *
  print 'Using installed binary mxTools'
except ImportError:
  try:
    from interscript.core.NewBuiltins.mxTools._mxTools import *
    print 'Using interscript binary mxTools'
  except:
    print 'Using interscript script mxTools'

try:
  from xmap import xmap
  print 'Using installed binary xmap'
except ImportError:
  try:
    from interscript.core.NewBuiltins.mxTools.xmap import xmap
    print 'Using interscript binary xmap'
  except:
    print 'Using interscript script xmap'

