#line 87 "web_weaver.ipk"
from interscript.weavers.multiplexor import multiplexor
from interscript.weavers.html import html_weaver
from interscript.weavers.html import cvt_code, cvt_text
from interscript.drivers.sinks.bufdisk import named_file_sink
from interscript.drivers.sinks.disk import simple_named_file_sink
import string
import traceback


class stacking_weaver(multiplexor):
  def mk_head(self, sink):
    w = sink.writeline
    w('<DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN">')
    w( '<HTML>')
    w( '<HEAD>')

    w('<TITLE>'+self.title+'</TITLE>')

    w( '<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">')
    if self.keywords.has_key('author'):
      author =self.keywords['author']
      self.frames_sink.writeline( '<META NAME="Author" CONTENT="'+author+'">')
    version = self.process.global_frame.version

    w( '<META NAME="Generator" CONTENT="Interscript '+version+'">')
    w( '</HEAD>')

  def mk_frame(self,name, orientation, subframes):
    print 'Making frame',name
    filename = self.pattern % name
    sink = named_file_sink(
      self.pass_frame,
      self.basedir+filename,
      self.master.weaver_prefix,
      eol=self.eol)
    self.mk_head(sink)
    pc = ''
    for frame_name,frame_percent,frame_src in subframes:
      pc = pc + str(frame_percent)+'%,'
    pc = pc[:-1]
    w = sink.writeline
    w( '<FRAMESET '+orientation+'="'+pc+'" scrolling="yes">')
    for frame_name,frame_percent,frame_src in subframes:
      w( '<FRAME NAME="'+frame_name+'" SRC="'+frame_src+'">')
    w( '</FRAMESET>')
    w( '</HTML>')

  def mk_frames(self, doc):
    top = self.pattern % 'top' # top level frame
    indexview = self.pattern % 'indexview'
    indexnav = self.pattern % 'indexnav'
    contents = self.pattern % 'toc'
    classref = self.pattern % 'classref'
    funcref = self.pattern % 'funcref'
    identref = self.pattern % 'identref'
    testref = self.pattern % 'testref'
    filestatus = self.pattern % 'filestatus'
    sectionref = self.pattern % 'sectionref'

    self.mk_frame('indexview','ROWS', (
      ('indexnav',20,indexnav),
      ('indexdat',80,contents)))
    self.mk_frame('top','COLS',(
      ('indexview',30,indexview),
      ('docview',70,doc)))

    nav = '';
    for filename, description in [
      (contents, 'Contents'),
      (classref, 'Classes'),
      (funcref, 'Functions'),
      (identref, 'Identifiers'),
      (testref, 'Tests'),
      (filestatus, 'Status'),
      (sectionref, 'Sections')
      ]:
      nav = nav + '<A HREF="'+filename+'" TARGET="indexdat">'+description+'</A> '
    nav = '<DIV CLASS="NAVIGATION">'+nav+'</DIV>'

    filename = self.pattern % 'indexnav'
    sink = named_file_sink(
      self.pass_frame,
      self.basedir+filename,
      self.master.weaver_prefix,
      eol=self.eol)
    self.mk_head(sink)
    w = sink.writeline
    w ('<BODY>')
    w (nav)
    w ('</BODY>')
    w ('</HTML>')


  def print_table(self,dict,sink):
    keys = dict.keys()
    keys.sort()
    w = sink.writeline
    w('<TABLE COLS="2" BORDER="1" CELLPADDING="2">')
    for k in keys:
      refs = dict[k]
      w('<TR><TD VALIGN="Top"><CODE> '+k+' </CODE></TD><TD> ')
      old_df = ''
      for sf,sc,df,dc in refs:
        key = (sf, sc)
        if self.anchor_file.has_key(key):
          child = self.anchor_file[key]
        else:
          child = ''
        anchor = '<A HREF='+child+'#'+sf+':'+str(sc)+' TARGET="docview">'+str(dc)+'</A>'

        if old_df != '': w(', ')
        if old_df != df:
          w(df+': '+ anchor )
          old_df = df
        else:
          w(anchor)
      w('</TD></TR>')
    w('</TABLE>')

  def __init__(self,parent_weaver, pattern='', break_list=None, **kwds):
    self.pass_frame = parent_weaver.pass_frame
    self.master = self.pass_frame.master
    self.process = self.pass_frame.process

    self.sequence = self.pass_frame.get_new_sequence_number()
    self.persistent_frame = self.master.get_persistent_frame(self.sequence)

    self.verbosity = self.pass_frame.verbosity
    self.debug_missing_methods = 0
    self.keywords = kwds

    self.original_filename = 'Unknown'

    self.toc_depth = self.keywords.get('toc_depth',99)
    self.base = [parent_weaver]
    parent_sink = parent_weaver.sink.name
    self.basedir = string.join(string.split(parent_sink,'/')[:-1],'/')+'/'
    if self.basedir == '/': self.basedir = ''
    print 'Base directory for stacking weaver is',self.basedir
    self.home_file = string.split(parent_sink,'/')[-1]
    if kwds.has_key('title'):
      self.title = kwds['title']
    elif hasattr(parent_weaver,'title'):
      self.title = parent_weaver.title
    else:
      self.title = self.home_file
    self.pattern = pattern
    if string.find(pattern,'%') == -1:
      self.pattern = self.pattern+'_%s.html'
    # break list
    self.break_list = [0]
    if break_list:
      for b in break_list: self.break_list.append(b)
    else:
      for i in range(1,40): self.break_list.append(i)

    self.stack = [parent_weaver]
    self.childcount = 0
    self.debug = 0
    self.protocol = 'stacking weaver'
    self.hcount = [1,0]
    self.acount = 0
    self.anchor_file = {}
    self.name = 'stacking weaver'
    self.eol = parent_weaver.sink.eol

    # table of contents
    self.toc = []

    self.home_anchor = '<A HREF="'+self.home_file+'">Home</A>'
    self.home_nav = '<DIV CLASS="NAVIGATION">'+self.home_anchor+'<BR><HR></DIV>'

    self.mk_frames(self.home_file)

    # cheat here, guess next exists :-)
    next = self.pattern%('%04d'%(self.childcount+1))
    next = '<A HREF="'+next+'">Next</A>'

    nav = ''
    if next : nav = nav + next+' '

    hnav = '<HR><DIV CLASS="NAVIGATION">'+nav+'<BR><HR></DIV>'
    parent_weaver._writeline(hnav)

#line 273 "web_weaver.ipk"
  def set_original_filename(self, filename):
    self.original_filename = filename

  def set_anchor(self, label):
    if not self.persistent_frame.has_key('anchors'):
      self.persistent_frame['anchors']  = {}
    href = self.pattern%('%04d'%(self.childcount))+'#'+label
    self._write('<A NAME="'+label+'"></A>')
    self.persistent_frame['anchors'][label]=href

  def get_anchor(self, label):
    href = None
    if self.persistent_frame.has_key('anchors'):
      if self.persistent_frame['anchors'].has_key(label):
        href =self.persistent_frame['anchors'][label]
    return href

  def ref_anchor(self, label):
    href = self.get_anchor(label)
    if href:
      self._write('<A HREF="'+href+'">'+label+'</A>')
    else:
      self._write('<EM>Unknown Label:'+label+'</EM>')

#line 300 "web_weaver.ipk"
  def code_head(self, tangler, secno):
    dst_filename = tangler.sink.name
    self.set_anchor(dst_filename+'['+str(secno)+']')
    for weaver in self.base:
      weaver.code_head(tangler, secno)

#line 317 "web_weaver.ipk"
  def _current_level(self): return len(self.hcount)-1
  def _pop_level(self): del self.hcount[-1]
  def _push_level(self): self.hcount.append(0)
  def _next_hnum(self): self.hcount[-1] = self.hcount[-1] + 1

  def head(self,level, text, atext='', anchor=''):
    while level > self._current_level():
      self._head(text, atext, anchor)  # synthesised dummy heading
      self._push_level()
    while level < self._current_level():
      self._pop_level()
      self._foot()
    assert level == self._current_level()
    self._next_hnum()
    self._head(text, atext, anchor)
    self._push_level()
    assert self._current_level() == level + 1

#line 339 "web_weaver.ipk"
  # if the current page has a break level equal to the current level pop it
  # (we'd print a footer first if we used them)
  def _foot(self):
    if self._trig(0) == self._current_level():
      self._popw()

  def _head(self,text, atext, anchor):
    level = self._current_level()
    if level == self._trig(1):
      self._pushw(level,text,atext,anchor)
    else:
     self._ins_head(level,text,atext,anchor)

  def __del__(self):
    try:
      self.mk_funcref(self.pattern % 'funcref','docview')
      self.mk_classref(self.pattern % 'classref','docview')
      self.mk_identref(self.pattern % 'identref','docview')
      self.mk_contents(self.pattern % 'toc','docview')
      self.mk_testref(self.pattern % 'testref','docview')
      self.mk_sectionref(self.pattern % 'sectionref','docview')
      self.mk_filestatus(self.pattern % 'filestatus')
    except:
      print 'Error in stacking weaver __del__ routine'
      traceback.print_exc()

  def get_formatted_heading_number(self, sep):
    hnumber = ''
    for i in range(1,len(self.hcount)-1):
      hnumber = hnumber + str(self.hcount[i])+'.'
    hnumber = hnumber + str(self.hcount[-1])
    return hnumber

  def _popw(self):
    if self.debug or self.verbosity>=6 :
      print 'Terminating weaver',self.stack[-1].name
    del self.stack[-1]
    self.base = [self.stack[-1]]

  def _new_child(self):
    self.childcount = self.childcount + 1
    last = self.persistent_frame.get('lastchild',-1)
    self.persistent_frame['lastchild']=max(last,self.childcount)
    return self.pattern % ('%04d' % self.childcount)

  def _pushw(self,level,text,atext,anchor):
    filename = self._new_child()
    #print 'Spawning Weaver',filename,'for',text
    self.base = [self.stack[-1]]
    hn = self.get_formatted_heading_number('.')+'.'
    hnum = self.get_formatted_heading_number('_')
    h = hn + ' '+text
    self.toc.append([level,hnum,filename,h])
    self._ensuremode('P')
    self._writeline( '<BR><A HREF="'+filename+'">'+h+'</A>')

    # create navigation links (kludge!)
    home = self.home_anchor
    up = None
    try:
      up = string.split(self.base[0].sink.name,'/')[-1]
      up_anchor = '<A HREF="'+up+'">Up</A>'
    except: pass

    if self.childcount > 1:
      prev = self.pattern % ('%04d'%(self.childcount-1))
      prev_anchor= '<A HREF="'+prev+'">Prev</A>'
    else: prev = None

    last = self.persistent_frame.get('lastchild',None)
    if last and self.childcount == last:
      next = None
    else:
      next = self.pattern%('%04d'%(self.childcount+1))
      next_anchor = '<A HREF="'+next+'">Next</A>'

    this = self.pattern%('%04d'%(self.childcount))
    this_anchor = '<A HREF="'+this+'">This</A>'

    nav = ''
    if next : nav = nav + next_anchor+' '
    if up : nav = nav + up_anchor+' '
    if prev : nav = nav + prev_anchor+' '
    if home: nav = nav + home+' '
    nav = nav + this_anchor+' <SMALL>['+self.original_filename+']</SMALL>'

    hnav = '<DIV CLASS="NAVIGATION">'+nav+'<BR><HR></DIV>'
    fnav = '<DIV CLASS="NAVIGATION"><BR><HR>'+nav+'</DIV>'

    extra = '<LINK type="text/html" rel="Contents" href="'+self.pattern % 'toc' +'">\r\n'
    extra = '<LINK type="text/html" rel="Identifiers" href="'+self.pattern % 'identref'+'">\r\n'
    extra = '<LINK type="text/html" rel="Classes" href="'+self.pattern % 'classref'+'">\r\n'
    extra = '<LINK type="text/html" rel="Functions" href="'+self.pattern % 'funcref'+'">\r\n'
    extra = extra + '<LINK type="text/html" rel="Start" href="'+self.home_file+'">\r\n'
    if next: extra = extra + '<LINK type="text/html" rel="Next" href="'+next+'">\r\n'
    if prev: extra = extra + '<LINK type="text/html" rel="Prev" href="'+prev+'">\r\n'
    if up: extra = extra + '<LINK type="text/html" rel="Section" href="'+up+'">\r\n'

    sink = named_file_sink(self.pass_frame, self.basedir + filename, self.master.weaver_prefix, self.eol)
    child = html_weaver(self.pass_frame,sink,title = h, pagehead = hnav, pagefoot=fnav, heading_prefix=hn, head_extra=extra)
    self.base = [child]
    self.stack.append(child)

  def _trig(self,offset=0):
    doc_level = len(self.stack)-1 # 0 origin
    return self.break_list[doc_level+offset]

  def _ins_head(self,level,text,atext,anchor):
    adjusted_level = level - self._trig()
    if anchor == '':
      anchor = 'a'+str(self.acount)
      self.acount = self.acount + 1
    hn = self.get_formatted_heading_number('.')+'.'
    hnum = self.get_formatted_heading_number('_')
    h = hn + ' '+text
    filename = self.pattern%('%04d'%self.childcount)
    self.toc.append([level,hnum,filename+'#'+anchor,h])
    for weaver in self.base:
      weaver.head(adjusted_level,text,atext,anchor)

#line 461 "web_weaver.ipk"
  def mk_contents(self,toc_filename,target):
    self.toc_sink = named_file_sink(
      self.pass_frame,
      self.basedir+toc_filename,
      self.master.weaver_prefix,
      eol=self.eol)
    self.mk_head(self.toc_sink)
    w = self.toc_sink.writeline
    w( '<BODY onload="loadHandler()">')
    tocline= """
<SCRIPT type="text/javascript">
<!--
function clickHandler() {
  var targetId, srcElement, targetElement;
  srcElement = window.event.srcElement;
  if (srcElement.className == "Button") {
    targetId = srcElement.id + "d";
    targetElement = document.all(targetId);
    if(targetElement.style.display == "none") {
      targetElement.style.display = "";
      srcElement.checked = true;
    } else {
      targetElement.style.display = "none";
      srcElement.checked = false;
    }
  }
}

// this function restores the status of the contents tree
// IE4 preserves the buttons states, but not the visibility
function loadHandler() {
  for (var srcId in document.all) {
    srcElement = document.all(srcId);
    if (srcElement != null && srcElement.className == "Button") {
      var targetId = srcId + "d";
      var targetElement = document.all(targetId);
      if(srcElement.checked == true) {
        targetElement.style.display = "";
      } else {
        targetElement.style.display = "none";
      }
    }
  }
}
document.onclick = clickHandler
document.onload = loadHandler
// -->
</SCRIPT>
"""
    if not target:
      nav = '<DIV CLASS="NAVIGATION">'+self.home_anchor+' '+self.frames_anchor+'<BR><HR></DIV>'
      self.toc_sink.writeline(nav)
    w('<H1>Table of Contents</H1>')
    w(tocline)
    last_level = -1
    if self.toc:
      i = 0
      level, hnum, href, text = self.toc[i]
      next_level = 0
      if len(self.toc) > i+1: next_level = self.toc[i+1][0]
      self.emit_contents_line(level, hnum, href, text, level<next_level, target)
      divid = 'h'+hnum+'d'
      w('<DIV ID='+divid+' style="display:">')
      last_level = level
    for i in range(1, len(self.toc)):
      level, hnum, href, text = self.toc[i]
      next_level = 0
      if len(self.toc) > i+1: next_level = self.toc[i+1][0]
      while level <= last_level:
        self.toc_sink.writeline('</DIV>')
        last_level = last_level - 1
      self.emit_contents_line(level, hnum, href, text, level<next_level, target)
      divid = 'h'+hnum+'d'
      w('<DIV ID='+divid+' style="display:">')
      last_level = level
    while 1 <= last_level:
      w('</DIV>')
      last_level = last_level - 1
    w( '</BODY>')
    w( '</HTML>')
    del self.toc_sink
    print 'stacked contents done'

  def emit_contents_line(self, level, hnum, href, text, enabled, target):
    self.toc_sink.writeline('&nbsp;'*(3*level))
    headid ='h'+hnum
    flag = 'disabled'
    if enabled: flag = ''
    self.toc_sink.writeline('<INPUT ID='+headid+' CLASS="Button" TYPE="Radio" '+flag+'>')
    if target:
      self.toc_sink.writeline('<A HREF="'+href+'" TARGET="'+target+'">'+text+'</A>')
    else:
      self.toc_sink.writeline('<A HREF="'+href+'">'+text+'</A>')

#line 603 "web_weaver.ipk"
  def mk_identref(self,filename,target):
    sink = named_file_sink(
      self.pass_frame,
      self.basedir+filename,
      self.master.weaver_prefix,
      eol=self.eol)
    self.mk_head(sink)
    w = sink.writeline
    w( '<BODY>')

    ids = self.master.ids
    if len(ids) == 0:
      ids = self.pass_frame.ids
    w('<H1>Index of Identifiers</H1>')
    self.print_table(ids,sink)

    w('</BODY>')
    w('</HTML>')

  def mk_sectionref(self,filename,target):
    sink = named_file_sink(
      self.pass_frame,
      self.basedir+filename,
      self.master.weaver_prefix,
      eol=self.eol)
    self.mk_head(sink)
    w = sink.writeline
    w( '<BODY>')

    dict = self.pass_frame.section_index
    w('<H1>Index of Sections</H1>')
    keys = dict.keys()
    keys.sort()
    w = sink.writeline
    w('<TABLE COLS="1" BORDER="1" CELLPADDING="2">')
    for k in keys:
      w('<TR><TD VALIGN="Top"><CODE> '+k+' </CODE>: ')
      nsections = len(dict[k])
      for i in range(nsections):
        name = k + '['+str(i+1)+']'
        anchor = '<A HREF='+self.get_anchor(name)+' TARGET="'+target+'">'+str(i+1)+'</A>'
        w(anchor+' ')
      w('</TD></TR>')
    w('</TABLE>')
    w('</BODY>')
    w('</HTML>')

  def mk_classref(self,filename,target):
    sink = named_file_sink(
      self.pass_frame,
      self.basedir+filename,
      self.master.weaver_prefix,
      eol=self.eol)
    w = sink.writeline
    self.mk_head(sink)
    w( '<BODY>')

    ids = self.master.classes
    if len(ids) == 0:
      ids = self.pass_frame.classes
    w('<H1>Index of Classes</H1>')
    self.print_table(ids,sink)
    w('</BODY>')
    w('</HTML>')

  def mk_funcref(self,filename,target):
    sink = named_file_sink(
      self.pass_frame,
      self.basedir+filename,
      self.master.weaver_prefix,
      eol=self.eol)
    w = sink.writeline
    self.mk_head(sink)
    w( '<BODY>')

    ids = self.master.functions
    if len(ids) == 0:
      ids = self.pass_frame.functions
    w('<H1>Index of Functions</H1>')
    self.print_table(ids,sink)

    w('</BODY>')
    w('</HTML>')

  def mk_testref(self,filename,target):
    sink = named_file_sink(
      self.pass_frame,
      self.basedir+filename,
      self.master.weaver_prefix,
      eol=self.eol)
    w = sink.writeline
    self.mk_head(sink)
    w( '<BODY>')

    ids = self.master.tests
    if len(ids) == 0:
      ids = self.pass_frame.tests
    w('<H1>Index of Tests</H1>')
    w('<TABLE CLASS="TEST_SUMMARY_TABLE" COLS="4" BORDER="1">')
    w('<TR><TH>No</TH><TH>Description</TH><TH>Kind</TH><TH>Result</TH><TR>')
    keys = ids.keys()
    keys.sort()
    for key in keys:
      descr, label, kind, result = ids[key]
      print 'test entry:',descr,label,kind,result
      href = self.get_anchor(label)
      print 'href=',href
      w('<TR><TD>'+str(key)+'</TD><TD><A TARGET="'+target+'" HREF="'+href+'">'+descr+'</A></TD><TD>'+kind+'</TD><TD>'+result+'</TD></TR>')
    w('</TABLE>')
    w('</BODY>')
    w('</HTML>')


  def mk_filestatus(self,filename):
    print 'Creating file status file:',filename
    filestatus_output = simple_named_file_sink(
      self.pass_frame,self.basedir+filename, self.master.weaver_prefix,eol='\r\n')
    filestatus_weaver = html_weaver(
      self.pass_frame,
      filestatus_output,title='File Status')
    filestatus_weaver.print_file_status(hlevel=1)

  def set_fc_anchor(self,file,count):
    filename = self.base[0].sink.basename
    self.anchor_file[(file,count)]=filename
    for weaver in self.base:
      weaver.set_fc_anchor(file,count)

  def heading_reference(self, *args, **kwds): pass # always generated
  def identifier_reference(self, *args, **kwds): pass # always generated
  def class_reference(self, *args, **kwds): pass # always generated
  def function_reference(self, *args, **kwds): pass # always generated
  def test_reference(self, *args, **kwds): pass # always generated


