#line 193 "weavers.ipk"
from interscript.weavers.multiplexor import multiplexor
from interscript.weavers.text import plain_text_weaver
from interscript.weavers.latex import latex_weaver
from interscript.weavers.html import html_weaver
from interscript.weavers.web import stacking_weaver
from interscript.drivers.sinks.bufdisk import named_file_sink

def mk_html(pass_frame,basename, directory, prefix):
 w = named_file_sink(pass_frame,directory+basename+'.html', prefix, eol='\r\n')
 return html_weaver(pass_frame,w,title=basename)

def mk_web(pass_frame,basename, directory, prefix):
  w = named_file_sink(pass_frame,directory+basename+'.html', prefix, eol='\r\n')
  w = html_weaver(pass_frame,w,title=basename)
  return stacking_weaver(w,basename+'_%s.html',(1,2,3,4,5,6,7,8,9,10))

def mk_latex(pass_frame,basename, directory, prefix):
  w = named_file_sink(pass_frame,directory+basename+'.tex', prefix)
  return latex_weaver(pass_frame,w)

def mk_text(pass_frame,basename, directory, prefix):
  w = named_file_sink(pass_frame,directory+basename+'.txt', prefix)
  return plain_text_weaver(pass_frame,w)

auto_weavers = {
  'html': mk_html,
  'web': mk_web,
  'latex': mk_latex,
  'text': mk_text
  }

def auto_weaver(pass_frame,basename,autoweave):
  prefix = pass_frame.master.weaver_prefix
  directory = pass_frame.master.weaver_directory
  weavers = []
  for w in autoweave:
    if auto_weavers.has_key(w):
      weavers.append( auto_weavers[w](pass_frame, basename, directory, prefix) )
  return multiplexor(pass_frame, weavers)

