#line 13 "python_tangler.ipk"
#---------------------------------------------------------
# python tangler: write to a file, insert source line numbers
# using '#line ' comments
# works for Python
from interscript.tanglers.base import tangler_base
import re
import string
from interscript.tokenisers.python import python_tokeniser
import keyword
import token

class python_tangler(tangler_base):
  def __init__(self,sink,weaver):
    tangler_base.__init__(self,sink,weaver)
    self.matchPOD = re.compile('^ *#@(.*)$')
    self.matchcomment = re.compile('^([^#]*)#.*$')
    self.excludeid = []
    self.userdict = {}
    self.tokeniser = python_tokeniser()
    self.language = 'python'

  def __del__(self):
    try:
      tokens = self.tokeniser.close()
    except:
        print 'Tokeniser error'
        print 'closing tokeniser for',self.sink.name

  def writeline(self,data,file,count,inhibit_sref=0):
    match = self.matchPOD.match(data)
    if match:
      command = match.group(1)
      py_exec(command,file,count,globals(),self.userdict)
    else:
      self.weaver.set_fc_anchor(file,count)
      # special hack to preserve leading #! line
      if self.sink.lines_written == 0 and len(data)>2:
        inhibit_sref = data[:2]=='#!'
      tangler_base.writeline(self,data,file,count, inhibit_sref)

      try:
        tokens = self.tokeniser.tokenize(data+'\n')
      except TokenError, e:
        print 'Tokeniser error',e
        print 'in file',file,'line',line
        print 'data['+data+']'


      dst_count = self.sink.lines_written
      dst_file = self.sink.name
      class_name = 0
      function_name = 0
      level = 0
      for kind,id,lstart,lend,dummy in tokens:
        if kind == token.INDENT:
          level = level + 1
        elif kind == token.DEDENT:
          level = level - 1
        if kind is token.NAME:
          if not (keyword.iskeyword(id) or id in self.excludeid):
            if not self.pass_frame.ids.has_key(id): self.pass_frame.ids[id]=[]
            self.pass_frame.ids[id].append((file,count,dst_file,dst_count))
            if class_name:
              #print 'class',id
              if not self.pass_frame.classes.has_key(id): self.pass_frame.classes[id]=[]
              self.pass_frame.classes[id].append((file,count,dst_file,dst_count))
              class_name = 0
            elif function_name:
              if not self.pass_frame.functions.has_key(id): self.pass_frame.functions[id]=[]
              self.pass_frame.functions[id].append((file,count,dst_file,dst_count))
              function_name = 0
          elif id == 'class':
            class_name = 1
          elif id == 'def':
            function_name = 1

  def write_comment(self,line,file,count):
    self.writeline('# '+line,file,count)

  def start_section(self, file, count):
    data = '#line '+str(count)+' '+'"'+file+'"'
    self._writeline(data)
    if self.weaver:
      self.weaver.echotangle(self.sink.lines_written,data)

  def get_comment_tangler(self):
    return script_comment_tangler(self.sink)

  def get_string_tangler(self,eol,width):
    return c_string_tangler(self.sink,self.get_weaver(),eol,width)

#line 106 "python_tangler.ipk"
class script_comment_tangler(tangler_base):
  def writeline(self,data,file,count,inhibit_sref=0):
    if self.weaver:
      self.weaver.writeline(data)
    self._writeline('# '+line)

