#line 23 "master_frame.ipk"
from interscript.frames.passf import pass_frame
from interscript.drivers.sources.disk import parse_source_filename
import pickle

class master_frame:
  def __init__(self,process,argument_frame):
    self.process = process
    for k in argument_frame.__dict__.keys():
      if process.verbosity > 4:
        print 'setting MASTER',k,'as',argument_frame.__dict__[k]
      setattr(self,k,argument_frame.__dict__[k])
    self.ids = {}
    self.iflist = []
    self.flist = []
    self.fdict = {}
    self.toc = []
    self.include_files = []
    self.classes = {}
    self.functions = {}
    self.sequence_limit = -1
    self.tests = {}
    self.persistent_frames = {}
    self.cache_name =parse_source_filename(
        self.filename+'.cache', self.source_prefix) [3]
    print 'cache=',self.cache_name
    try:
      cache = open(self.cache_name,'r')
      self.persistent_frames = pickle.load(cache)
      cache.close()
      del cache
      print 'loaded master frame from cache'
    except: pass

#line 80 "master_frame.ipk"
    for passno in range(self.passes):
      curpass = pass_frame(self, passno)
      self.ids = curpass.ids        # idlist
      self.flist = curpass.flist    # output file list
      self.iflist = curpass.iflist  # input file list
      self.toc = curpass.toc        # table of contents
      self.include_files = curpass.include_files # include files
      self.classes = curpass.classes # classes
      self.functions = curpass.functions # functions
      self.tests = curpass.tests # functions

      if self.sequence_limit == -1:
        self.sequence_limit = curpass.sequence
      elif self.sequence_limit != curpass.sequence:
        print 'WARNING: SEQUENCE COUNTER DISPARITY BETWEEN PASSES'
      ds = curpass.fdict
      dd = self.fdict

      file_count = 0
      stable_file_count = 0
      unstable_file_count = 0
      new_file_count = 0
      for k in ds.keys():
        file_count = file_count + 1
        if not dd.has_key(k):
          dd[k]=(ds[k],passno)
          new_file_count = new_file_count + 1
        else:
          if ds[k]=='unchanged':
            stable_file_count = stable_file_count + 1
          else:
            unstable_file_count = unstable_file_count + 1
          if ds[k]!='unchanged' or dd[k][0]!='unchanged':
            dd[k]=(ds[k],passno)
      converged = file_count == stable_file_count
      if converged:
        print 'All',file_count,'output files stable on pass',passno,' -- breaking'
        break
      else:
        print 'Of',file_count,'files, only',stable_file_count,'were stable on pass',passno
        print 'There were',new_file_count,'new files,'
        print 'and',unstable_file_count,'unstable files.'
    try:
      cache = open(self.cache_name,'w')
      pickle.dump(self.persistent_frames, cache)
      cache.close()
      del cache
      print 'Pickled persistent frames in', self.cache_name
    except:
      print 'Pickle FAILURE'

  def get_master_frame(self): return self

  def get_persistent_frame(self, seq):
    if not self.persistent_frames.has_key(seq):
      self.persistent_frames[seq]={}
    return self.persistent_frames[seq]

