#line 34 "input_frame.ipk"
import string
import re
import traceback
import sys
import os
import tempfile

# these imports _should_ come from the global frame!
from interscript.drivers.sources.base import eof, eoi
from interscript.drivers.sources.disk import named_file_source
from interscript.drivers.sources.disk import parse_source_filename
from interscript.drivers.sources.disk import loadfile
from interscript.drivers.sinks.bufdisk import named_file_sink
from interscript.drivers.sinks.disk import simple_named_file_sink

from interscript.tanglers.c import c_tangler
from interscript.tanglers.cpp import cpp_tangler
from interscript.tanglers.python import python_tangler
from interscript.tanglers.perl import perl_tangler
from interscript.tanglers.java import java_tangler
from interscript.tanglers.tcl import tcl_tangler
from interscript.tanglers.doc import doc_tangler
from interscript.tanglers.null import null_tangler
from interscript.tanglers.data import data_tangler

from interscript.parsers.html import sgml_wrapper, html_filter
try:
  import interscript.utilities.diff
except:
  pass

def compile_parse_tab(res):
  return map(lambda x: [re.compile(x[0]), x[1]], res)


#line 80 "input_frame.ipk"
class input_frame:

  def __init__(self, pass_frame, src, reg_list, weaver, userdict, depth):
    # the display
    self.pass_frame = pass_frame
    self.master = pass_frame.master
    self.process = self.master.process
    self.global_frame = self.process.global_frame

    self.weaver = weaver
    self.weaver_stack = []

    self.depth = depth
    self.source = src
    self.userdict = userdict
    self.reg_list = reg_list
    self.read_buffer = []

    self.tangler_stack = []
    self.tangler = None
    self.line_offset = 0
    self.original_filename = src.get_source_name()
    self.weaver.set_original_filename(self.original_filename)
    self.head_offset = 0
    self.verbosity = pass_frame.verbosity
    self.tabwidth = self.master.tabwidth

    self.cont_re = re.compile('^$|^ (.*)$')
    self.any_line_re = re.compile('^(.*)$')

    if self.verbosity>=6:
      print 'initialising input frame',src.get_source_name()
    self.post_methods()

  def __del__(self):
    if self.verbosity>=6:
      print 'frame',self.source.name,'deleting'

#line 123 "input_frame.ipk"
  def post_methods(self):
    # input frame methods
    method_names = self.__class__.__dict__.keys()
    is_begin_or_end_method = lambda x: x[:3]=='end' or x[:5]=='begin'
    method_names = filter(is_begin_or_end_method, method_names)
    method_names = method_names + [
      'head','heading','push_head','pop_head','set_head',
      'set_warning_character',
      'doc','p','eop','cite_url',
      'output','c_output','cpp_output',
      'python_output','perl_output',
      'interscript_output',
      'push','pop','select','comment','resume_code',
      'tangler_push','tangler_pop','tangler_set', # temporarily!
      'untangle',
      'weave','weave_line','tangle',
      'print_identifier_cross_reference',
      'print_contents',
      'print_file_list',
      'print_source_list',
      'print_include_list',
      'print_class_reference',
      'print_file_status',
      'get_weaver',
      'table_row', 'table_rule',
      'item',
      'include_file','include_source',
      'include_code','insert_code','display_code',
      'include_html','html',
      'capture_output','print_output',
      'capture_python_output','print_python_output','print_python_test_output',
      'set_weaver','get_weaver', 'push_weaver','pop_weaver',
      'get_attribute',
      'interscript_from_options',
      'python','test_python',
      'set_anchor','ref_anchor'
      ]
    for m in method_names:
      exec 'self.userdict[m]=self.'+m

    # pass frame methods
    method_names = [
      'get_pass_frame'
    ]
    for m in method_names:
      exec 'self.userdict[m]=self.pass_frame.'+m

    # processs frame methods
    method_names = ['get_process_frame']
    for m in method_names:
      exec 'self.userdict[m]=self.process.'+m

    #master frame methods
    method_names = ['get_master_frame']
    for m in method_names:
      exec 'self.userdict[m]=self.master.'+m

#line 183 "input_frame.ipk"
  def close(self):
    if self.verbosity>=6:
      print 'closing frame',self.source.name
    del self.userdict
    del self.tangler
    del self.weaver
    del self.reg_list
    while self.tangler_stack: del self.tangler_stack[-1]
    while self.weaver_stack: del self.weaver_stack[-1]
    try: raise eoi
    except: pass

#line 197 "input_frame.ipk"
  def file_pass(self):
    while 1:
      try:
        file,count,line = self.readline()

        echo = 0
        if self.userdict.has_key('echo_input'):
          echo = self.userdict['echo_input']
        if self.verbosity>=6 or echo and self.verbosity!=0:
          print '%s %6s: %s' % (file,count,line)
        for r in self.reg_list:
          match = r[0].match(line)
          if match:
            r[1](match,file,count,self.process.global_frame.__dict__,self.userdict)
            break
      except eoi:
        if self.verbosity>=3: print 'EOI detected'
        if self.verbosity>=4: print 'Poping input stack'
        if self.tangler:
          self.select(None)
        self.close()
        return
      except KeyboardInterrupt:
        print '!!!!!!!!! KEYBOARD INTERRUPT !!!!!!!!!'
        self.process.update_files = 0
        self.close()
        raise KeyboardInterrupt
      except SystemExit,value:
        print '!!!!!!!!! SYSTEM EXIT !!!!!!!!!'
        self.process.update_files = 0
        self.close()
        raise SystemExit,value
      except:
        if self.verbosity>=1:
          print '!!!!!!!!! PROGRAM ERROR !!!!!!!!!'
          traceback.print_exc()
        self.process.update_files = 0
        self.close()
        sys.exit(1)

#line 244 "input_frame.ipk"
  def interscript_from_options(self,*args):
    from interscript  import run_from_options
    svdout = sys.stdout
    svdin  = sys.stdin
    svderr = sys.stderr
    run_from_options(args)
    sys.stdout = svdout
    sys.stdin  = svdin
    sys.stderr = svderr

#line 271 "input_frame.ipk"
  def get_attribute(self,name,default=None):
    if self.userdict.has_key(name):
      return self.userdict[name]
    else:
      return default

#line 289 "input_frame.ipk"
  def begin(self):
    ho = self.head_offset
    self.select(None)
    inpt = input_frame(
      self.pass_frame,
      self.source,
      [],
      self.weaver,
      self.userdict.copy(),
      self.depth)
    inpt.head_offset = ho
    inpt.set_warning_character(python=self.python_warn)
    inpt.file_pass()

  def end(self):
    self.select(None)
    raise eoi

#line 360 "input_frame.ipk"
  def include_file(self,name):
    if self.verbosity>=2:
      print 'input from',name
    self.pass_frame.include_files.append((self.depth+1,'interscript',name))
    self.include_source(named_file_source(self.pass_frame,name, self.source.directory))

  def include_source(self,source):
    self.select(None)
    ho = self.head_offset
    inpt = input_frame(
      self.pass_frame,
      source,
      [],
      self.weaver,
      self.userdict.copy(),
      self.depth+1)
    inpt.head_offset = ho
    inpt.set_warning_character(python='@')
    inpt.file_pass()
    self.weaver.set_original_filename (self.original_filename)

#line 403 "input_frame.ipk"
  def insert_code(self,name):
    self.tangler_push(self.tangler)
    self.pass_frame.include_files.append((self.depth+1,'code: '+self.tangler.language,name))
    inpt = input_frame(
      self.pass_frame,
      named_file_source(self,name, self.source.directory),
      [(self.any_line_re,self.process.do_web)],
      self.weaver,
      self.userdict.copy(),
      self.depth+1)
    inpt.file_pass()

  def include_code(self,name,tangler):
    self.tangler_set(None)
    self.pass_frame.include_files.append((self.depth+1,'code: '+self.tangler.language,name))
    inpt = input_frame(
      self.pass_frame,
      named_file_source(self,name, self.source.directory),
      [(self.any_line_re,self.process.do_web)],
      self.weaver,
      self.userdict.copy(),
      self.depth+1)
    inpt.select(tangler)
    inpt.file_pass()

#line 444 "input_frame.ipk"
  def include_html(source):
    self.select(None)
    r = []
    self.pass_frame.include_files.append((self.depth+1,'html: '+self.tangler.language,name))
    inpt = input_frame(
      self.pass_frame,
      source,
      r,
      self.weaver,
      self.userdict.copy(),
      self.depth+1)
    inpt.html_parser = sgml_wrapper(html_filter(inpt))
    r.append((inpt.any_line_re,inpt.do_html))
    inpt.file_pass()

  def html(self):
    self.select(None)
    r = []
    inpt = input_frame(
      self.pass_frame,
      self.source,
      r,
      self.weaver,
      self.userdict.copy(),
      self.depth)
    inpt.html_parser = sgml_wrapper(html_filter(inpt))
    r.append((inpt.any_line_re,inpt.do_html))
    inpt.file_pass()



#line 477 "input_frame.ipk"
  def get_verbosity(self):
    if self.userdict.has_key('verbosity'):
      return self.userdict['verbosity']
    return self.verbosity

#line 484 "input_frame.ipk"
  def get_weaver(self):
    return self.weaver

  def set_weaver(self,w):
    tmp = self.weaver
    self.weaver = w
    return tmp

  def push_weaver(self,w):
    self.weaver_stack.append(self.weaver)
    self.weaver = w

  def pop_weaver(self):
    self.weaver = self.weaver_stack[-1]
    del self.weaver_stack[-1]

#line 502 "input_frame.ipk"
  def set_anchor(self,label):
    if self.tangler:
      self.tangler.weaver.set_anchor(label)
    else:
      self.weaver.set_anchor(label)

  def ref_anchor(self,label):
    self.weaver.ref_anchor(label)

  def set_warning_character(self,python=None):
    res = self.make_parse_tab(pywarn=python)
    res = compile_parse_tab(res)
    self.reg_list = res
    self.python_warn = python

  def normal_line(self,data,file,count):
    weaver = self.get_weaver()
    if self.tangler:
      self.tangler.writeline(data,file,count)
    else:
      weaver.writeline(data)

#line 528 "input_frame.ipk"
  def enqueue_input(self,file, count, line):
    self.read_buffer.append((file,count,line))

  def dequeue_input(self):
    data = self.read_buffer[0]
    del self.read_buffer[0]
    return data

  def line(self, number, filename):
    self.inpt.original_file = filename
    self.inpt.line_offset = number - inpt.src.get_lines_read()

  def readline(self):
    while 1:
      if self.read_buffer:
        return self.dequeue_input()
      try:
        line = self.source.readline()
        self.real_filename = self.source.get_source_name()
        self.real_count = self.source.get_lines_read()
        self.original_count = self.real_count + self.line_offset
        line = string.rstrip(line)
        self.line = string.expandtabs(line,self.tabwidth)
        return (self.original_filename,self.original_count,self.line)
      except KeyboardInterrupt:
        # should inhibit output for process, not globally
        self.process.update_files = 0
        raise KeyboardInterrupt
      except eof:
        if self.verbosity>=4:
          print 'readline: EOF'
        self.line = None
        raise eoi
      else:
        if self.process.verbosity>=1:
          print 'program error in readline:',sys.exc_info()
        self.process.update_files = 0

#line 586 "input_frame.ipk"
  def untangle(self,name):
    if not self.tangler:
      raise 'untangle without active tangler'
    f = open(name)
    data = f.readlines()
    f.close()
    self.tangler.sink.writeline('@select(output("'+name+'"))')
    for line in data:
      l = string.rstrip(line)
      if len(l):
        if l[0]=='@': l = '@'+l
      self.inpt.tangler.sink.writeline(l)
    self.tangler.sink.writeline('@select(None)')
    self.tangler.weaver.begin_small()
    self.tangler.weaver.writeline('Included '+name+', '+str(len(data))+' lines.')
    self.tangler.weaver.end_small()
    self.tangler.weaver.line_break()

#line 646 "input_frame.ipk"
# regexp's for the main functions

  def make_parse_tab(self, pywarn = None):
    res = []
    if pywarn:
      res = res + [
        ['^'+pywarn+'('+pywarn+')(.*)$',self.do_quote_at],
        ['^'+pywarn+'(.*[-+*/%:,\([{]) *(#.*)?$', self.do_exec_suite],
        ['^'+pywarn+'(.*)$',self.do_exec_line]
        ]


    res = res + [
      ['^(.*)$',self.do_web]
      ]
    return res

#line 673 "input_frame.ipk"
  def collect_stuff(self,prefix, cont_re, echo):
    saved = prefix
    try:
      file2,count2,line = self.readline()
      match = cont_re.match(line)
      while match:
        if echo:
          print '%s %6s: %s' % (file2,count2,line)
        body = match.group(1)
        if not body: body = ''
        saved = saved+'\n'+body
        file2,count2,line = self.readline()
        match = cont_re.match(line)
      self.enqueue_input(file2,count2,line)
    except eoi:
      pass
    saved = saved + '\n'
    return saved

  def collect_lines_upto(self,terminal):
    term_re = re.compile('^'+terminal+'$')
    saved = []
    file,count,line = self.readline()
    match = term_re.match(line)
    while not match:
      saved.append(line)
      file,count,line = self.readline()
      match = term_re.match(line)
    return saved

  def collect_upto(self,terminal):
    return string.join(self.collect_lines_upto(terminal), '\n')+'\n'

  def python(self, terminal='@end_python'):
    file = self.original_filename
    count = self.original_count
    glb = self.global_frame.__dict__
    user = self.userdict
    data = self.collect_upto(terminal)
    self.process.py_exec(data,file,count,glb,user)

#line 726 "input_frame.ipk"
  def print_diff_table(self, comparison,
    actual_heading='Actual', expected_heading='Expected',
    ok_message='Data compared equal.',
    diff_message='Differential follows.'):

    equal = len(comparison) == 0
    our_weaver = self.get_weaver()
    if not equal:
      if diff_message:
        our_weaver.writeline(diff_message)
      our_weaver.begin_table('Actual','Expected', CLASS='DIFF')
      for section in comparison:
        left = section[0][1:]
        right = section[1][1:]
        left = string.join(left,'\n')
        right = string.join(right,'\n')
        our_weaver.table_row([left, right])
      our_weaver.end_table()
    else:
      if ok_message:
        our_weaver.writeline(ok_message)

#line 750 "input_frame.ipk"
  def test_python(self,
    hlevel=None,
    descr=None,
    source_filename=None,
    source_terminator=None,
    expect_filename=None,
    expect_terminator=None,
    diff_context=0):

    testno = self.pass_frame.get_new_test_number()
    testlabel = 'test_'+str(testno)
    test_record = self.pass_frame.tests[testno]=\
      [descr,testlabel,'python','Aborted']
    expect = expect_filename or expect_terminator

    # print heading
    if hlevel: our_hlevel = hlevel
    else: our_hlevel = self.last_head+1
    if descr == None: descr = 'Test'
    self.head(our_hlevel,'Test '+str(testno)+': '+descr)
    self.set_anchor(testlabel)

    our_weaver = self.get_weaver()

    if source_terminator:
      our_weaver.writeline('On-the-fly python test script follows.')
      source_origin_line = self.original_count
      source_origin_file = self.original_filename
      test_code = self.collect_lines_upto(source_terminator)
      our_weaver.script_head('python',source_origin_file)
      for i in range(len(test_code)):
        our_weaver.echotangle(source_origin_line+i+1,test_code[i])
      our_weaver.script_foot('python',source_origin_file)
    elif source_filename:
      our_weaver.writeline('Python test script from file '+source_filename+'.')

    if expect_terminator:
      expected_origin_line = self.original_count
      expected_origin_file = self.original_filename
      expected_output = self.collect_lines_upto(expect_terminator)
    elif expect_filename:
      # FIX to make document relative
      our_weaver.writeline('Expected output from file '+expected_filename+'.')
      expected_lines = loadfile(expect_filename)

    # execute the test code

    if source_filename:
      our_source_filename = source_filename
    else:
      our_source_filebase = tempfile.mktemp()
      our_source_filename = our_source_filebase + '_test.py'
      f = open(our_source_filename,'w')
      f.write(string.join(test_code,'\n')+'\n')
      f.close()

    our_weaver.writeline('Actual output follows.')
    status, actual_output = self.print_python_output(our_source_filename)
    cmd_ok = status == 0

    # delete the file if it was created anonymously
    if not source_filename:
      os.remove(our_source_filename)

    if expect:
      try:
        diff_lines = interscript.utilities.diff.diff_lines
        comparison = diff_lines(actual_output, expected_output, context=diff_context)
        equal = len(comparison)==0
        self.pass_frame.tests[testno][2]= 'diff'
        self.pass_frame.tests[testno][3]= ('Fail','Ok')[equal]
        if not equal:
          our_weaver.writeline('On-the-fly expected output follows.')
          our_weaver.expected_head(expected_origin_file)
          for i in range(len(expected_output)):
            our_weaver.echotangle(expected_origin_line+i+1,expected_output[i])
          our_weaver.expected_foot(expected_origin_file)
          self.print_diff_table(comparison)
      except ImportError:
        our_weaver.writeline('Unable to import diff to perform comparison.')
      except KeyboardInterrupt: raise
      except SystemExit: raise
      except:
        traceback.print_exc()
    else:
      self.pass_frame.tests[testno][3]='Inspect'

#line 856 "input_frame.ipk"
  def do_exec_line(self,match, file,count,glb,user):
    self.process.py_exec(match.group(1),file,count,glb,user)

#line 861 "input_frame.ipk"
  def do_exec_suite(self,match,file,count,glb,user):
    saved = self.collect_stuff(match.group(1), self.cont_re, user['echo_input'])
    self.process.py_exec(saved,file,count,glb,user)

#line 867 "input_frame.ipk"
  def do_web(self,match,file,count,glb,user):
    self.normal_line(match.group(1),file,count)

#line 872 "input_frame.ipk"
  def do_quote_at(self,match,file,count,glb,user):
    self.normal_line(match.group(1)+match.group(2),file,count)

#line 877 "input_frame.ipk"
  def do_html(self,match,file,count,glb,user):
    self.html_parser.writeline(match.group(1),file,count)

#line 890 "input_frame.ipk"
  def tangler_push(self,f):
    self.tangler_stack.append(self.tangler)
    self.tangler = f

  def tangler_pop(self):
    self.tangler = self.tangler_stack[-1]
    del self.tangler_stack[-1]

  def tangler_set(self,f):
    self.tangler = f

#line 910 "input_frame.ipk"
#---------------------------------------------------------
# USER COMMANDS

#line 920 "input_frame.ipk"
  def output(self,f):
    filename = self.master.tangler_directory+f
    sink = named_file_sink(self.pass_frame,filename,self.master.tangler_prefix)
    return data_tangler(sink,self.get_weaver())

  def c_output(self,f):
    filename = self.master.tangler_directory+f
    sink = named_file_sink(self.pass_frame,filename,self.master.tangler_prefix)
    return c_tangler(sink,self.get_weaver())

  def cpp_output(self,f):
    filename = self.master.tangler_directory+f
    sink = named_file_sink(self.pass_frame,filename,self.master.tangler_prefix)
    return cpp_tangler(sink,self.get_weaver())

  def python_output(self,f):
    filename = self.master.tangler_directory+f
    sink = named_file_sink(self.pass_frame,filename,self.master.tangler_prefix)
    return python_tangler(sink,self.get_weaver())

  def perl_output(self,f):
    filename = self.master.tangler_directory+f
    sink = named_file_sink(self.pass_frame,filename,self.master.tangler_prefix)
    return perl_tangler(sink,self.get_weaver())

  # temporarily, we'll use a data tangler
  def interscript_output(self,f):
    filename = self.master.tangler_directory+f
    sink = named_file_sink(self.pass_frame,filename,self.master.tangler_prefix)
    return data_tangler(sink,self.get_weaver())

#line 1002 "input_frame.ipk"
  def push(self,f):
    if self.tangler: self.code_foot()
    self.tangler_push(f)
    if self.tangler: self.code_head()

  def pop(self):
    if self.tangler: self.code_foot()
    self.tangler_pop()
    if self.tangler: self.code_head()

#line 1013 "input_frame.ipk"
  def select(self,f):
    if self.tangler: self.code_foot()
    self.tangler_set(f)
    if self.tangler: self.code_head()

  def code_head(self):
    dst_filename = self.tangler.sink.name
    dst_lineno = self.tangler.sink.lines_written
    src_filename = self.original_filename
    src_lineno = self.original_count

    index = self.pass_frame.section_index
    list = index.get(dst_filename, [])
    list.append((dst_lineno, src_filename, src_lineno))
    index[dst_filename]=list
    secno = len(list)
    self.weaver.code_head(self.tangler, secno)

  def code_foot(self):
    dst_filename = self.tangler.sink.name
    index = self.pass_frame.section_index
    list = index.get(dst_filename, [])
    secno = len(list)
    self.weaver.code_foot(self.tangler, secno)

  def begin_comments(self):
    if self.tangler:
      self.tangler_push(self.tangler.get_comment_tangler())
    else:
      self.tangler_push(None)

  def end_comments(self):
    self.tangler_pop()

  def resume_code(self):
    self.tangler_pop()

  def comment(self,v):
    self.get_weaver().write_comment(v)

  def begin_string(self,eol = ' ', width = 0):
    if self.tangler:
      self.tangler_push(self.tangler.get_string_tangler(eol,width))
    else:
      self.tangler_push(None)

  def end_string(self):
    tangler_pop()

  def weave(self,s):
    weaver = self.get_weaver()
    weaver.write(s)

  def weave_line(self,s):
    weaver = self.get_weaver()
    weaver.writeline(s)

  def tangle(self,s, inhibit_sref=0):
    if self.tangler:
      line = self.original_count
      file = self.original_filename
      self.tangler.writeline(s,file,line,inhibit_sref)
    else:
      print "tangle: No tangler for",s

#line 1081 "input_frame.ipk"
  def print_contents(self,*args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_contents, args, kwds)

  def print_file_list(self,*args,**kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_file_list, args, kwds)

  def print_file_status(self,*args,**kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_file_status, args, kwds)

  def print_source_list(self, *args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_source_list, args, kwds)

  def print_include_list(self, *args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.print_include_list, args, kwds)

  def macro(self,name):
    self.select(None)
    weaver = self.get_weaver()
    return data_tangler(memory(name),weaver)

  def print_identifier_cross_reference(self, *args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.identifier_reference, args, kwds)

  def print_class_reference(self, *args, **kwds):
    self.select(None)
    weaver = self.get_weaver()
    apply(weaver.class_reference, args, kwds)

#line 1124 "input_frame.ipk"
  def capture_output(self,command):
    commands = self.global_frame.commands
    status, output = commands.getstatusoutput(command)
    data = string.split(output,'\n')
    return (status,data)

  def print_output(self,command):
    status, data = self.capture_output(command)
    weaver = self.get_weaver()
    weaver.test_output_head(command, status)
    for i in range(len(data)):
      line = data[i]
      l = string.rstrip(line)
      weaver.echotangle(i+1,l)
    weaver.test_output_foot(command, status)
    return (status, data)

  def capture_python_output(self,script):
    return self.capture_output(sys.executable+' '+script)

  def print_python_output(self,script):
    return self.print_output(sys.executable+' '+script)

  def print_python_test_output(self,script, descr):
    testno = self.pass_frame.get_new_test_number()
    testlabel = 'test_'+str(testno)
    self.pass_frame.tests[testno]=[descr,testlabel,'python','Unknown']
    self.set_anchor(testlabel)
    return self.print_python_output(script)

#line 1162 "input_frame.ipk"
  def head(self, level, text, atext='', anchor=''):
    level = int(level)
    level = level + self.head_offset
    self.last_head = level
    if self.get_verbosity()>=3: print ('  '*(level-1))+'"'+text+'"'
    self.pass_frame.toc.append((level,text))
    weaver = self.get_weaver()
    if self.tangler: self.code_foot()
    self.tangler_set(None)
    weaver.head(level,text,atext,anchor)

  # like heading, but to be used in code as well:
  # doesn't switch to document mode, doesn't do
  # code headings and footings

  def heading(self, level, text, atext='', anchor=''):
    level = int(level)
    level = level + self.head_offset
    self.last_head = level
    if self.get_verbosity()>=3: print ('  '*(level-1))+'"'+text+'"'
    self.pass_frame.toc.append((level,text))
    weaver = self.get_weaver()
    weaver.head(level,text,atext,anchor)

  def push_head(self, amt=1):
    self.head_offset = self.head_offset + amt

  def pop_head(self, amt=1):
    self.push_head(-amt)

  def set_head(self, amt=None):
    if amt != None:
      self.head_offset = amt - 1
    else:
      self.head_offset = self.last_head - 1

#line 1200 "input_frame.ipk"
  def doc(self):
    weaver = self.get_weaver()
    if self.tangler: self.code_foot()
    self.tangler_set(None)

  def p(self): # end a paragraph and start a new one
    weaver = self.get_weaver()
    weaver.par()

  def eop(self): # end a paragraph without starting a new one
    weaver.eop()

#line 1214 "input_frame.ipk"
  def cite_url(self, url):
    weaver = self.get_weaver()
    weaver.cite_url(url)

#line 1220 "input_frame.ipk"
  def begin_table(self, *headings, **kwds):
    apply(self.get_weaver().begin_table, headings, kwds)

  def table_row(self, *data):
    self.get_weaver().table_row(data)

  def end_table(self):
    self.get_weaver().end_table()

  def table_rule(self):
    self.get_weaver().table_rule()

#line 1234 "input_frame.ipk"
  def begin_list(self, style):
    weaver = self.get_weaver()
    weaver.begin_list(style)

  def end_list(self):
    weaver = self.get_weaver()
    weaver.end_list()

  def item(self,*args, **kwds):
    weaver = self.get_weaver()
    apply(weaver.item, args, kwds)

  def begin_numbered_list(self, start=1):
    weaver = self.get_weaver()
    weaver.begin_numbered_list(start)

  def end_numbered_list(self):
    weaver = self.get_weaver()
    weaver.end_numbered_list()

  def begin_numbered_list_item(self):
    weaver = self.get_weaver()
    weaver.begin_numbered_list_item()

  def end_numbered_list_item(self):
    weaver = self.get_weaver()
    weaver.end_numbered_list_item()

  def begin_bullet_list(self):
    weaver = self.get_weaver()
    weaver.begin_bullet_list()

  def end_bullet_list(self):
    weaver = self.get_weaver()
    weaver.end_bullet_list()

  def begin_bullet_list_item(self):
    weaver = self.get_weaver()
    weaver.begin_bullet_list_item()

  def end_bullet_list_item(self):
    weaver = self.get_weaver()
    weaver.end_bullet_list_item()

  def begin_keyed_list(self):
    weaver = self.get_weaver()
    weaver.begin_keyed_list()

  def end_keyed_list(self):
    weaver = self.get_weaver()
    weaver.end_keyed_list()

  def begin_keyed_list_item(self, key):
    weaver = self.get_weaver()
    weaver.begin_keyed_list_item(key)

  def end_keyed_list_item(self):
    weaver = self.get_weaver()
    weaver.end_keyed_list_item()

#line 1296 "input_frame.ipk"
  def begin_emphasize(self):
    weaver = self.get_weaver()
    weaver.begin_emphasize()

  def end_emphasize(self):
    weaver = self.get_weaver()
    weaver.end_emphasize()

  def begin_strong(self):
    weaver = self.get_weaver()
    weaver.begin_strong()

  def end_strong(self):
    weaver = self.get_weaver()
    weaver.end_strong()

  def begin_italic(self):
    weaver = self.get_weaver()
    weaver.begin_italic()

  def end_italic(self):
    weaver = self.get_weaver()
    weaver.end_italic()

  def begin_bold(self):
    weaver = self.get_weaver()
    weaver.begin_bold()

  def end_bold(self):
    weaver = self.get_weaver()
    weaver.end_bold()

  def begin_big(self):
    weaver = self.get_weaver()
    weaver.begin_big()

  def end_big(self):
    weaver = self.get_weaver()
    weaver.end_big()

  def begin_small(self):
    weaver = self.get_weaver()
    weaver.begin_small()

  def end_small(self):
    weaver = self.get_weaver()
    weaver.end_small()

  def begin_code(self):
    weaver = self.get_weaver()
    weaver.begin_code()

  def end_code(self):
    weaver = self.get_weaver()
    weaver.end_code()

#line 1354 "input_frame.ipk"
  def begin_displayed_code(self):
    weaver = self.get_weaver()
    weaver.begin_displayed_code()

  def end_displayed_code(self):
    weaver = self.get_weaver()
    weaver.end_displayed_code()

  # this command is used to print out a code file 'verbatim'
  def display_code(self,name):
    self.pass_frame.include_files.append((self.depth+1,'code',name))
    self.begin_displayed_code()
    filename = parse_source_filename(name, self.source.directory)[3]
    f = open(filename)
    data = f.readlines()
    f.close()
    weaver = self.get_weaver()
    for line in data:
      l = string.rstrip(line)
      weaver.writeline(l)
    self.end_displayed_code()

#line 1377 "input_frame.ipk"

