#line 77 "source_drivers.ipk"
#---------------------------------------------------------
# gets input from a named file
from interscript.drivers.sources import source_open_error
from interscript.drivers.sources.base import source
from interscript.drivers.sources.base import eof
import string
import os

def loadfile(filename):
   "return a list of lines, trailing whitespace removed"
   try:
     f = open(filename)
   except:
     raise source_open_error,filename
   data = f.readlines()
   f.close()
   for i in range(len(data)):
     data[i]=string.rstrip(data[i])
   return data

def parse_source_filename(filename, prefix):
  pathlist = string.split(filename,'/')
  if prefix == '':
    prefix = os.getcwd()
    if prefix[-1] != os.sep:
      prefix = prefix + os.sep
  directory = prefix + string.join(pathlist[:-1],os.sep)
  if directory[-1] != os.sep:
    directory = directory + os.sep
  basename = pathlist[-1]
  full_filename = directory + basename
  return pathlist, basename, directory, full_filename

class named_file_source(source):
  def __init__(self,pass_frame,filename, prefix=''):
    source.__init__(self)
    pass_frame.iflist.append(filename)
    self.name = filename

    pathlist, self.basename, self.directory, self.filename =\
      parse_source_filename(filename, prefix)

    try:
      self.file = open(self.filename,'r')
      self.closed = 0
    except:
      raise source_open_error,filename

  def __del__(self):
    if getattr(self,'file'): self.file.close()

  def readline(self):
    if self.closed:
      raise eof
    line = self.file.readline()
    if len(line)==0: raise eof
    self.lines_read = self.lines_read + 1
    return line

  def get_filename(self):
    return self.name

