#line 212 "sink_drivers.ipk"
import string
from interscript.drivers.sinks.base import sink
from interscript.drivers.sinks import sink_open_error
from interscript.drivers.sinks.util import mk_dir

class simple_named_file_sink(sink):
  def __init__(self,pass_frame,input_filename, prefix='', eol='\n'):
    self.eol = eol

    # compute absolute pathname, and create directories if necessary
    # we don't use posixpath because we're enforcing an _interscript_
    # pathname convention here
    pathlist = string.split(input_filename,'/')
    self.basename = pathlist[-1]
    pathname = mk_dir(prefix, pathlist)
    try:
      file = open(pathname,'w')
    except:
      raise sink_open_error,pathname
    sink.__init__(self, name = input_filename, file = file)
    pass_frame.flist.append(pathname)

  def __del__(self):
    self.file.close()

  def raw_write(self,line): self.file.write(line)
  def raw_eol(self): self.raw_write(self.eol)

