import vp

from Application  import Application
from Window       import Window
from Canvas       import Canvas
from Menu         import PulldownMenu
from WidgetButton import PushButton

# -------------------------------------------------------------------------
# Test function

def MenuCB( item ): print 'MenuCB:', item.GetName(), 'was selected' 


def test():
	app  = Application('WindowTest')
	win  = Window()
	
	# Add a work area

	canvas = Canvas({ 'size': (500,500) })
	win.AddWorkArea( canvas )
	canvas.AddChild( PushButton({ 'name': 'WorkArea' }) )

	# Add a menu to the window

	win.AddMenu( PulldownMenu({
        'title': 'Menu1', 
		'items': [
		    ('Item1', MenuCB),
			('Item2', MenuCB),
			('Item3', MenuCB),
			vp.theQuitCommand
			]
		}))

	# Add a message area

	win.SetMessage( 'Message area' )

	# Add a command area 

	import X
	from Box import EqualSizeBox, Glue

	hb = PushButton({ 'name': 'Help',   'callback': MenuCB })
	cb = PushButton({ 'name': 'Cancel', 'callback': MenuCB })
	ob = PushButton({ 'name': 'Ok',     'callback': MenuCB })
	ob.SetXResources({ 'showAsDefault': X.TRUE })

	win.AddCommandArea( EqualSizeBox({
	    'child_list': [
			Glue( 10, vp.FIXED ),
		    ob,
			Glue( 5, vp.ELASTIC ),
			cb,
			Glue( 5, vp.ELASTIC ),
			hb,
			Glue( 10, vp.FIXED )
			]
		}))
	app.Run()

test()
	
