import vp, ModelView

from Application      import Application
from Window           import Window
from ModelView        import EditorModel, EditorView
from TreeMV           import TreeEditorView, TreeNodeModel, \
	                         TreeNodeView, NestableTreeNodeView
from Menu             import PulldownMenu

# ------------------------------------------------------------------
# TestApp: tests the EditorModel class

class TestApp( Application, EditorModel ):
	
	def __init__( self ): 
		print 'Initializing...'
		Application.__init__( self, 'test' )
		EditorModel.__init__( self )

		self.mv_windows['Graphical2'].SetSize( 425, 350 )
		self.mv_windows['Graphical1'].SetMessage( 'A hierarchical treeview' )
		self.mv_windows['Graphical2'].SetMessage( 'A nested treeview' )
		
		for category in self.mv_windows.keys():
			self.mv_windows[category].AddMenu( PulldownMenu({
				'title': 'View',
				'items': [('Realize',   getattr(self, 'Realize' + category) ),
				          ('UnRealize', getattr(self, 'UnRealize' + category) )]
				 }))
				

	# --------------------------------------------------------------
	# Menu callbacks

	def RealizeGraphical1( self, item ): self.RealizeView('Graphical1')
	def RealizeGraphical2( self, item ): self.RealizeView('Graphical2')
	def UnRealizeGraphical1( self, item ): self.UnRealizeView('Graphical1')
	def UnRealizeGraphical2( self, item ): self.UnRealizeView('Graphical2')

# ------------------------------------------------------------------
# Assign window and view classes to the model classes

ModelView.AddWindowClass( TestApp, 'Graphical1', Window )
ModelView.AddWindowClass( TestApp, 'Graphical2', Window )

ModelView.AddViewClass( TestApp, 'Graphical1', TreeEditorView )
ModelView.AddViewClass( TestApp, 'Graphical2', EditorView )

ModelView.AddViewClass( TreeNodeModel, 'Graphical1', TreeNodeView )
ModelView.AddViewClass( TreeNodeModel, 'Graphical2', NestableTreeNodeView )

# ------------------------------------------------------------------
# test program

def test():
	app = TestApp()
	app.SetImmediateMode( vp.FALSE )

	print 'Creating tree-nodes...'

	root = TreeNodeModel( app, 'Root' )
	for name in [ 'A', 'B', 'C' ]:
		root.AddChild( TreeNodeModel( app, name ) )

	B = root.children[1]
	for name in [ 'B1', 'B2', 'B3']:
		B.AddChild( TreeNodeModel( app, name ) )

	root.children[2].AddLink( B.children[2] ) # add an extra link

	app.Load( root )

	print 'Set immediate mode'
	app.SetImmediateMode( vp.TRUE )
	app.RealizeView('Graphical1')
	app.RealizeView('Graphical2')
	app.Run()


test()
