import vp

from Application   import Application
from Window        import Window
from Canvas        import Canvas
from Circle        import Circle
from Rectangle     import Rectangle
from TextPrimitive import TextPrimitive

class CentralEventHandler:

	def EnterEH( self, target, client_data, xevent, e ):
		print 'CentralEventHandler.Enter: target =', target.GetName()
	
	def LeaveEH( self, target, client_data, xevent, e ):
		print 'CentralEventHandler.Leave: target =', target.GetName()

	def MouseDownEH( self, target, client_data, xevent, e ):
		print 'CentralEventHandler.MouseDownEH: target =', target.GetName()
		target.MouseDownEH( target, client_data, xevent, e )
		
	def MouseUpEH( self, target, client_data, xevent, e ):
		print 'CentralEventHandler.MouseUpEH: target =', target.GetName()
		target.MouseUpEH( target, client_data, xevent, e )


def test():
	app     = Application('test')
	win     = Window()
	win.SetMessage( 'This demonstrates event redirection' )

	central = CentralEventHandler()
	can     = Canvas({ 'size': (400,300), 'selection_rect': vp.TRUE })
	win.AddWorkArea( can )

	# setting 'editmode' to TRUE will cause control points to be displayed
	# when the graphic has been selected.

	circ = Circle({ 'diameter' : 40, 
					'editmode' : vp.TRUE,
					'draggable': vp.TRUE })
	can.AddChild( circ )

	text = TextPrimitive({ 'pos'      : (10,50), 
						   'editmode' : vp.TRUE,
						   'draggable': vp.TRUE, 
						   'string'   : 'Hi there!' })
	can.AddChild( text )

	rect = Rectangle({ 'pos'      : (100,100),
					   'size'     : (50,50),
					   'name'     : 'hugin',
					   'outline'  : vp.TRUE,
					   'fill'     : vp.TRUE,
					   'show_name': vp.TRUE,
					   'draggable': vp.TRUE,
					   'editmode' : vp.TRUE })
	can.AddChild( rect )

	# redirect some events to the CentralEventHandler; ENTER and LEAVE 
	# events are only supported for widget-based classes

	circ.Subscribe( vp.MOUSE_DOWN, central.MouseDownEH, None )
	circ.Subscribe( vp.MOUSE_UP,   central.MouseUpEH,   None )

	text.Subscribe( vp.MOUSE_DOWN, central.MouseDownEH, None )
	text.Subscribe( vp.MOUSE_UP,   central.MouseUpEH,   None )

	rect.Subscribe( vp.MOUSE_DOWN, central.MouseDownEH, None )
	rect.Subscribe( vp.MOUSE_UP,   central.MouseUpEH,   None )

	can.Subscribe( vp.ENTER,    central.EnterEH,   None )
	can.Subscribe( vp.LEAVE,    central.LeaveEH,   None )
	can.Subscribe( vp.MOUSE_UP, central.MouseUpEH, None )

	app.Run()

test()
	
