# --------------------------------------------------------------------------
# Tests the Object input/output module. 

from ObjectIO    import File, Storable
from Object      import Object 
from TreeNode    import TreeNode 
from Application import Application

# --------------------------------------------------------------------------
# Make some storable classes

class Foo( Storable, Object ): 

	# ------------------------------------------------------------------
	# Object I/O

	def _WriteTo( self, file ): self.WriteAttr( file, 'name', self.name )
		
	def _ReadFrom( self, file ): (attr, self.name) = self.ReadAttr( file )


class STreeNode( Storable, TreeNode ):

	# ------------------------------------------------------------------
	# Object I/O

	def LoadClass( self, cname ): return eval( cname )

	def _WriteTo( self, file ):
		self.WriteAttr( file, 'name', self.name )
		self.WriteAttr( file, 'count', len(self.children) )

		for child in self.children: 
			child.WriteTo( file )


	def _ReadFrom( self, file ):
		(attr, self.name) = self.ReadAttr( file )
		(attr, count)     = self.ReadAttr( file )

		for i in range(count):
			child = self.ReadFrom( file )
			self.AddChild( child )
		
		
class DummyApp( Storable, Object ):

	def DoSomething( self ):
		self.list1    = []
		self.list2    = []
		self.list_ref = self.list1
		self.list3    = ['joe', None]

		for i in range(4):
			self.list1.append( Foo({ 'name': 'foo' + `i` }) )

		for item in self.list1:
			self.list2.append( item )

		self.tree = STreeNode({ 'name': 'root' })

		for name in ['aap', 'noot', 'mies']:
			self.tree.AddChild( STreeNode({ 'name': name }) )

		for name in ['orca', 'walvis', 'zeehond']:
			self.tree.children[1].AddChild( STreeNode({ 'name': name }) )

	# ------------------------------------------------------------------
	# Object I/O

	def LoadClass( self, cname ): return eval( cname )

	def SaveTo( self, fname ):
		ofile = File( fname, 'w' )

		self.WriteAttr( ofile, 'list1', self.list1 )
		self.WriteAttr( ofile, 'list2', self.list2 )
		self.WriteAttr( ofile, 'list_ref', self.list_ref )
		self.WriteAttr( ofile, 'list3', self.list3 )
		self.WriteAttr( ofile, 'tree', self.tree )

		ofile.Close()

	def LoadFrom( self, fname ):
		ifile = File( fname, 'r' )

		(attr, self.list1) = self.ReadAttr( ifile )
		(attr, self.list2) = self.ReadAttr( ifile )
		(attr, self.list_ref) = self.ReadAttr( ifile )
		(attr, self.list3) = self.ReadAttr( ifile )
		(attr, self.tree)  = self.ReadAttr( ifile )

		ifile.Close()

		print 'list1 =', self.list1
		for item in self.list1:
			print item.GetName()

		print 'list2 =', self.list2
		for item in self.list2:
			print item.GetName()

		print 'list_ref =', self.list_ref
		for item in self.list_ref:
			print item.GetName()

		print 'list3 =', self.list3
		for item in self.list3:
			print item

		print 'tree =', self.tree
		self.tree.PrintTree()

def test():
	app = DummyApp()
	app.DoSomething()
	app.SaveTo( 'iotest' )
	app.LoadFrom( 'iotest' )

test()
