import vp

from Application  import Application
from Window       import Window
from Canvas       import Canvas
from Box          import Box
from Menu         import PopupMenu, PulldownMenu, OptionMenu
from Rectangle    import Rectangle
from WidgetButton import PushButton
from MiscGraphic  import Label, Separator

# -------------------------------------------------------------------------
# Test function

def MenuCB( item ):
	print 'MenuCB:', item.GetName(), 'was selected' 

def NewMenuCB( item ):
	print 'Replacing old menu with new one'
	
	menu = item.GetParent()
	menu.SetTitle( 'NewMenu' )
	menu.SetMenu([ ('Item1', MenuCB), ('Item2', MenuCB), ('Item3', MenuCB)] )
		
def AddItemCB( item ):
	print 'Add an item to the menu'
	
	menu = item.GetParent()
	menu.AddItem( ('New item', MenuCB) )
						

def test():
	app  = Application('MenuTest')
	win  = Window({ 'layout': vp.MWC })
	win.SetMessage( 'Pulldown with left-mouse, popup with right-mouse' )

	# Add a view with a popup menu

	canvas = Canvas({ 'size': (400, 200) })
	win.AddWorkArea( canvas )

	# Add some menus to the window

	win.AddMenu( PulldownMenu({
		  'title': 'File',
		  'items': [ vp.theQuitCommand ]
		  }))

	win.AddMenu( PulldownMenu({
		  'title' : 'DynaMenu', 
		  'items': [
		      ('Replace menu', NewMenuCB), 
			  ('Add item',     AddItemCB), 
			  Separator(),
			  ('Item3',        MenuCB), 
			  ('Item4',        MenuCB), 
			  Separator(),
			  ('Item5',        MenuCB), 
			  ('Item6',        MenuCB)
			  ]
		}))
	win.AddMenu( PulldownMenu({
		  'title' : 'Menu2', 
		  'items': [
		      ('Item1', MenuCB), 
			  ('Item2', MenuCB), 
			  ('Item3', MenuCB), 
			  ('Item4', MenuCB), 
			  ('Item5', MenuCB), 
			  ('Item6', MenuCB)
			  ]
		}))

	# Add an option-menu

	canvas.AddChild( OptionMenu({ 
		  'pos'  : (0,70),
		  'title': 'Other attrs:',
		  'items': [('Item1', MenuCB),('Item2', MenuCB)] 
		  }))

	# Add a button with a popup-menu

	butt = PushButton({ 'name': 'aPushButton', 'draggable': vp.TRUE })
	canvas.AddChild( butt )
	butt.AddPopup( PopupMenu({
		  'title': 'ButtonMenu', 
		  'items': [
		      ('Replace menu', NewMenuCB), 
			  ('Item2',        MenuCB), 
			  ('Item3',        MenuCB)
			  ]
		}))

	# Add a label with a popup-menu

	label = Label({ 'name': 'aLabel', 'pos': (0, 40) })
	canvas.AddChild( label )
	label.AddPopup( PopupMenu({
		  'title': 'LabelMenu', 
		  'items': [('Item1', MenuCB), ('Item2', MenuCB), ('Item3', MenuCB)]
		}))

	# Add a rectangle with a popup-menu aswell

	rect = Rectangle({ 'pos': (100, 100), 'size': (50, 50) })
	canvas.AddChild( rect )
	rect.AddPopup( PopupMenu({
		  'title': 'RectangleMenu', 
		  'items': [('Item1', MenuCB), ('Item2', MenuCB), ('Item3', MenuCB)]
		}))
	om = OptionMenu({ 
		  'title': 'Other attrs:',
		  'items': [('Item1', MenuCB),('Item2', MenuCB)] 
		  })
	win.AddCommandArea( Box({
		  'child_list': [PushButton({'name': 'aButton'}),om]
		  }))
		                 
	app.Run()

test()
	
