import vp

from Application  import Application
from Canvas       import Canvas
from Box          import Box
from Window       import Window
from WidgetButton import PushButton, ToggleButton
from MiscGraphic  import Label
from Frame        import Frame
from RadioGroup   import RadioGroup


def test():
	app = Application('test')
	win = Window()
	win.SetSize( 400, 450 )

	canvas = Canvas()
	win.AddWorkArea( canvas )

	frame = Frame({
		  'pos'  : (10, 10),
		  'child': Box({
		        'alignment' : vp.VLEFT, 
				'child_list': [PushButton({'name': 'aButton'}),
				               PushButton({'name': 'anotherButton'})]
				})
	})
	canvas.AddChild( frame )

	label_frame = Frame({
		  'label':'aTitle', 
		  'pos'  : (10, 100),
		  'child': Box({
		        'alignment' : vp.VLEFT,
				'child_list': [PushButton({'name': 'aButton'}),
		                       PushButton({'name': 'anotherButton'})]
			})
	})
	canvas.AddChild( label_frame )

	rg = RadioGroup()
	radio_box = Frame({
		  'label': 'Font style',
		  'pos'  : (10, 200),
		  'child': Box({
		      'alignment' : vp.VLEFT,
			  'child_list': [
				  ToggleButton({ 'name':'Roman', 'radio_group':rg }),
				  ToggleButton({ 'name':'Italic','radio_group':rg }),
				  ToggleButton({ 'name':'Bold',  'radio_group':rg })
				  ]
		      })
		  })
	canvas.AddChild( radio_box )

	hbox = Frame({
		  'label': 'Font style',
		  'pos'  : (10, 350),
		  'child': Box({
		        'child_list': [
					ToggleButton({ 'name':'Roman', 'radio_group':rg }),
				    ToggleButton({ 'name':'Italic','radio_group':rg }),
					ToggleButton({ 'name':'Bold',  'radio_group':rg })
					]
			})
	})
	canvas.AddChild( hbox )

	app.Run()


test()
