import vp, Font

from Application     import Application
from Window          import Window
from Canvas          import Canvas
from TextPrimitive   import TextPrimitive
from WidgetButton    import PushButton
from Menu            import PulldownMenu
from Rectangle       import Rectangle

# -------------------------------------------------------------------------
# Test function
#
# At the moment only TextPrimitive, Label and its descendents (PushButton,
# ToggleButton, ArrowButton) support changing the font at runtime. 
#
# Setting the font of other classes, i.e. the Text class, must be done by
# specifying the fontList X-resource in a resource file.
#

button = None
textprim  = None

def SetFontCB( item ):
	name = item.GetName()

	if name == 'Courier-Roman':
		fontname = '-*-courier-medium-r-normal-*-12-*-*-*-*-*-iso8859-1'
	elif name == 'Haebfix-Medium':
		fontname = '-*-haebfix-medium-r-normal-*-*-*-*-*-*-*-*-*'
	else:
		fontname = '-*-palatino-bold-r-normal-*-*-120-*-*-*-*-iso8859-1'

	button.SetFont( fontname )
	textprim.SetFont( fontname )
	print 'Text size =', textprim.GetSize()
	
	
def test():
	app = Application( 'FontTest' )
	win = Window()
	win.AddMenu( PulldownMenu({
        'title': 'Font',
		'items': [
		    ('Courier-Roman',  SetFontCB),
			('Haebfix-Medium', SetFontCB),
			('Palatino-Bold',  SetFontCB)
			]
		}))
	can = Canvas({ 'size': (300, 200) })
	win.AddWorkArea( can )

	global button, textprim

	button = PushButton({'pos': (10, 60), 
						 'name': 'Monty Python\'s flying Circus'})
	can.AddChild( button )

	textprim = TextPrimitive({'pos':(10, 110),
						  'string': 'Monty Python\'s flying Circus'})
	can.AddChild( textprim )

	# make a rectangle act as the bbox of the text primitive

	bbox = Rectangle()

	textprim.x.LinkTo( bbox.x )
	textprim.y.LinkTo( bbox.y )
	textprim.width.LinkTo( bbox.width )
	textprim.height.LinkTo( bbox.height )

	can.AddChild( bbox )

	app.Run()

test()
