import vp, sys

from Application  import Application
from Window       import Window
from MiscCommands import OpenFileCommand
from Menu         import PulldownMenu
from Text         import Text

class FileViewApp( Application ):
	
	def __init__( self ):
		Application.__init__( self, 'FileViewer' )
		self._CreateWindow()
		if len(sys.argv) > 1: self.LoadFile( sys.argv[1] )

	def _CreateWindow( self ):
		self.textview = Text()
		win = Window()
		win.AddWorkArea( self.textview )
		win.AddMenu( PulldownMenu({
			'title' : 'File', 
			'items': [ 
				OpenFileCommand({'callback': self.LoadFile}), 
				vp.theQuitCommand 
				]
			}))

	def LoadFile( self, fname ): 
		if fname != None: self.textview.LoadFile( fname )

def test():
	app = FileViewApp()
	app.Run()

test()

