import X, Xmd

import vp

from Application  import Application
from Window       import Window
from Canvas       import Canvas
from Frame        import Frame
from Box          import Box, Glue
from WidgetButton import PushButton, ToggleButton, ArrowButton
from TextControls import TextList, TextField, LabeledTextField
from Sketcher     import RubberBandSketcher, RubberRectSketcher
from MiscGraphic  import ScrolledViewPort


def CB( control ):
	print 'Callback called by', control.GetName()


def test():
	app = Application( 'ControlTest' )
	win = Window()

	rrc = Canvas({ 'size': (400,400) })
	rrs = RubberRectSketcher({ 'canvas': rrc, 'callback': CB })

	rbc = Canvas({ 'size': (400,400) })
	rbs = RubberBandSketcher({ 'canvas': rbc, 'callback': CB })

	win.AddWorkArea( Box({
		'alignment': vp.VLEFT,
		'child_list': [
			Frame({
				'label': 'Various buttons:',
				'stretchability': (vp.ELASTIC, vp.FIXED),
				'child': Box({ 
					'child_list': [
						PushButton({ 'name': 'PushButton', 'callback':CB }),
						ToggleButton({ 'name': 'ToggleButton', 'callback':CB}),
						PushButton({ 
							'name'    : 'DefaultButton',
							'xres'    : {'showAsDefault':  X.TRUE},
							'callback': CB
							}),
						ToggleButton({
							'name'         : 'ToggleButton w.o. indicator',
							'use_indicator': vp.FALSE,
							'callback'     : CB
							}),
						ArrowButton({
							'callback': CB,
							'xres'    : {'arrowDirection': Xmd.ARROW_LEFT} 
							}),
						ArrowButton({
							'callback': CB,
							'xres'    : {'arrowDirection': Xmd.ARROW_RIGHT} 
							})
						]
					})
				}),
			Box({
				'child_list': [
					Frame({
						'label': 'Some text-controls:',
						'stretchability': (vp.FIXED, vp.ELASTIC),
						'child': Box({
							'alignment' : vp.VLEFT,
							'child_list': [
								TextField({
									'name'          : 'TextField', 
									'stretchability': (vp.ELASTIC, vp.FIXED),
									'characters'    : 15, 
									'text'          : 'foo.py',
									'callback'      : CB
									}),
								Glue( 10, vp.FIXED ),
								LabeledTextField({
									'label'         : 'LabeledTextField', 
									'stretchability': (vp.ELASTIC, vp.FIXED),
									'characters'    : 15, 
									'text'          : 'foo.py',
									'callback'      : CB
									}),
								Glue( 10, vp.FIXED ),
								TextList({
									'name' : 'TextList', 
									'list' : ['aastor', 'brasem', 'dahlia',\
											  'ereprijs','sijs','kemphaan',\
											  'geelgors','zeehond','watertor'],
									'size'  : ( 100, 120 ),
									'stretchability': (vp.ELASTIC, vp.ELASTIC),
									'callback': CB
									})
								]
							})
						}),
					Glue( 10, vp.FIXED ),
					Frame({
						'label': 'RubberRectSketcher:',
						'child': ScrolledViewPort({ 'view': rrc })
						}),
					Glue( 10, vp.FIXED ),
					Frame({
						'label': 'RubberBandSketcher:',
						'child': ScrolledViewPort({ 'view': rbc })
						})
					]
				})
			]
		}))

	app.Run()

test()
