import vp

from Application  import Application
from Window       import Window
from Canvas       import Canvas
from Box          import Box
from GraphicLink  import ArrowLink
from WidgetButton import PushButton

# -------------------------------------------------------------------------
# Process class

class Process( Box ):

	def __init__( self, argdict = {} ):
		argdict = self.MergeDefaults( argdict, {
			'alignment' : vp.HCENTER, 
			'draggable' : vp.TRUE,
			'child_list': [PushButton( {'name': 'inport'} ),
						   PushButton( {'name': 'outport'} )]
			})
		Box.__init__( self, argdict )

# -------------------------------------------------------------------------
# Test function

def test():
	app = Application( 'BoxTest3' )
	win = Window()
	win.SetMessage( 
		'The button boxes can be dragged with the middle-mouse button' )

	can = Canvas({ 'size': (600, 600) })
	win.AddWorkArea( can )

	# make 2 Process instances and link them together with an ArrowLink

	p1 = Process({ 'pos': (10,300) })
	can.AddChild( p1 )

	p2 = Process({ 'pos': (200,50) })
	can.AddChild( p2 )

	can.AddChild( ArrowLink({
		'name'         :'stream',  
		'show_name'    : vp.TRUE,
		'begin_graphic': p1,  
		'end_graphic'  : p2 
		}))
	app.Run()


test()


		
		
		
		


		
		

			  
