# -------------------------------------------------------------------------
# MODULE:      vp
#
# DESCRIPTION: 
#     Contains constants and global variables which should be accessable 
#     throughout the vpApp framework.
#
# USAGE:
#     > import vp
#
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, <per@cwi.nl>

# -------------------------------------------------------------------------
# General constants:

TRUE  = 1
FALSE = 0
NULL  = 0
ON    = 1
OFF   = 0

# -------------------------------------------------------------------------
# Some X keycode constants: ASCII characters are in range(256)

BACKSPACE = 65288
DELETE    = 65535
RETURN    = 65293
TAB       = 65289

def ConvertKeycode( kc ):
	if kc in range(256):
		return chr(kc)
	else:
		return None
	

# -------------------------------------------------------------------------
# CLASS:         SelectionSet
#
# DESCRIPTION: 
#     Keeps the set of selected objects. Clients can subscribe to 
#     'selection-events' by using the 'AddSelectionCallback' method.
# 

class SelectionSet:

	def __init__( self ): 
		self.slist = []
		self.cb_list = []
		self.notify_inspector = FALSE

	def SetEmpty( self ):
		for graphic in self.slist[:]:
			graphic.SetSelected( FALSE )
		self.slist = []

	def Add( self, graphic ): 
		if graphic not in self.slist:
			self.slist.append( graphic )
			if len(self.cb_list) != 0: 
				for cb in self.cb_list: cb( graphic )  # execute callback

	def Remove( self, graphic ):
		self.slist.remove( graphic )

	def AddSelectionCallback( self, cb_handler ):
		if cb_handler not in self.cb_list:
			self.cb_list.append( cb_handler )

	def RemoveSelectionCallback( self, cb_handler ):
		if cb_handler in self.cb_list:
			self.cb_list.remove( cb_handler )

	def GetSelection( self ): return self.slist[:]  # return a copy of the list
		
	def IsEmpty( self ): return len(self.slist) == 0
		
		
# -------------------------------------------------------------------------
# Global variables

theApplication         = None
theClipboard           = []
theSelection           = SelectionSet()
theDestination         = None
theCurrentPopupNode    = None  # in order to find the node which popped-up the
                               # menu

theInfoDialog          = None
theQuestionDialog      = None
theWorkingDialog       = None
theFileSelectionDialog = None

theUndoCommand         = None
theQuitCommand         = None

theLastCommand         = None   # for undo action

theInspector           = None


# -------------------------------------------------------------------------
# Constants for the Graphic class

# Event type constants

ENTER            = 0
LEAVE            = 1
MOUSE_DOWN       = 2
MOUSE2_DRAG      = 3  # done with middle-mouse button
MOUSE1_DRAG      = 4  # done width left-mouse button
MOUSE_UP         = 5
KEYPRESS         = 6
RESIZE           = 7
EXPOSE           = 8
WIDGET_DESTROYED = 9

# Misc constants

CPB              = 6  # size of the control-point-box
HORIZONTAL       = 0
VERTICAL         = 1

# Stretchability 

ELASTIC          = 0
FIXED            = 1


# -------------------------------------------------------------------------
# Constants for the Box class

HCENTER   = 0  # align centers along the horizontal axis
HTOP      = 1  # align tops 
HBOTTOM   = 2  # align bottoms
VCENTER   = 3  # align centers along the vertical axis
VLEFT     = 4  # align left sides
VRIGHT    = 5  # align right sides



# -------------------------------------------------------------------------
# Constants for the Command classes

HAS_NO_UNDO = 0
HAS_UNDO    = 1

DISABLED    = 0
ENABLED     = 1


# -------------------------------------------------------------------------
# Constants for the Canvas class

EDIT_MODE        = 1
CREATE_MODE      = 2

POINT_SKETCHER   = 0
RBAND_SKETCHER   = 1
RRECT_SKETCHER   = 2
RCIRCLE_SKETCHER = 3

RETAINED_MODE    = 1   # drag modes
OUTLINE_MODE     = 2

# -------------------------------------------------------------------------
# Constants for the Font module

PIXEL = 0
POINT = 1

# -------------------------------------------------------------------------
# Constants for the TextList class

SORTED         = 0
REVERSE_SORTED = 1
UNSORTED       = 2

# -------------------------------------------------------------------------
# Constants for the TextView class

EDITABLE     = 1
NON_EDITABLE = 0


# -------------------------------------------------------------------------
# Constants for the ClassBrowser class

CODE_NONE      = 0     # do not display code  
CODE_GNUCLIENT = 1     # use the gnuclient to display the code  
CODE_WINDOW    = 2     # use a separate read-only codeview window


# -------------------------------------------------------------------------
# Constants for the Window class

MAIN_WINDOW   = 1
DIALOG_WINDOW = 2

CWM           = 1  
MWC           = 2

EXPLICIT      = 0 
POINTER       = 1 
