# -------------------------------------------------------------------------
# MODULE:      Text
#
# DESCRIPTION:  
#     Contains the Text class 
# 

import Xm, X, Xmd, os

import vp
from WidgetObject  import WidgetObject

debug = vp.FALSE

# -------------------------------------------------------------------------
# CLASS:         Text 
#
# INHERITS FROM: View : WidgetObject : Graphic : (TreeNode,DatumDict) : Object
# 
# DESCRIPTION: 
#

class Text( WidgetObject ):

	widget_class = Xm.Text

	# ------------------------------------------------------------------
	# Init methods:

	def __init__( self, argdict = {} ):
		#
		# Args can be the following: 
		# - 'editable'      : (TRUE/FALSE=default)
		# - 'rows'          : <num of rows> (default=24)
		# - 'cols'          : <num of columns> (default=80)
		# - 'scrollable'    : (TRUE=default/FALSE)
		# - 'string': <string>
		#
		self.rows       = 24
		self.cols       = 80
		self.editable   = vp.FALSE
		self.scrollable = vp.TRUE

		WidgetObject.__init__( self, argdict )

		self.filename     = ''
		self.file         = None
		self.lineno       = 1
		self.buffer       = None
		self.SetRowCol( self.rows, self.cols )
		self.SetDefaultXRes()


	def SetDefaultXRes( self ):
		if self.editable:
			self.SetXResources({
				  'editable'              : X.TRUE,
				  'font'                  : vp.theDefaultFont.GetFont(),
				  'editMode'              : Xmd.MULTI_LINE_EDIT,
				  'autoShowCursorPosition': X.TRUE
				  })
		else:
			self.SetXResources({
				  'editable'              : X.FALSE,
				  'font'                  : vp.theDefaultFont.GetFont(),
				  'editMode'              : Xmd.MULTI_LINE_EDIT,
				  'autoShowCursorPosition': X.TRUE
				  })


	def CreateWidget( self ):
		if self.scrollable == vp.TRUE:
			pw = self.parent.GetWidget()
			self.text_w = pw.CreateScrolledText( 'Text', self.xresources )
			self.text_w.ManageChild()
			self.w      = self.text_w.Parent()  # ScrolledWindow widget
			self.InitWidget()
		else:
			WidgetObject.CreateWidget( self )

		if hasattr( self, 'string'): 
			self.SetString( self.string )
	

	# ------------------------------------------------------------------
	# Misc private methods:

	def GetTextWidget( self ):
		if self.scrollable == vp.TRUE:
			return self.text_w
		else:
			return self.w


	# ------------------------------------------------------------------
	# Misc public methods:

	def SetRowCol( self, rows, cols ):
		txt = ''
		for i in range(cols):
			txt = txt + 'x'

		(lw, lh) = vp.theDefaultFont.GetStringSize( txt )
		txt = None
		if debug:
			print 'Text.SetRowCol: size needed =', lw, lh*rows, \
				  'font point-size =', vp.theDefaultFont.GetPointSize()
		self.SetSize( lw, lh*rows )
		self.SetNaturalSize( lw, lh*rows )
		
		
	def LoadFile( self, filename ):
		if self.filename == filename:
			return 

		self.filename = filename
		self.file     = open( filename, 'r' )   # open file for reading 
		self.lineno   = 1

		if self.file == None:
			self.filename = ''
			return

		self.buffer = self.file.readlines() # read all lines in file
		self.file.close()                   # close the file

		txt = ''
		for i in range(len(self.buffer)):
			txt = txt + self.buffer[i]

		self.SetString( txt )


	# ------------------------------------------------------------------
	# Access methods:

	def GetBaseline( self ):
		#
		# Return the x-pos of the first baseline
		#
		return self.GetTextWidget().TextGetBaseline( )


	def GetInsertionPosition( self ):
		#
		# Return the position of the insert cursor
		#
		return self.GetTextWidget().TextGetInsertionPosition( )


	def GetLastPosition( self ):
		#
		# Return the position at the end of the buffer
		#
		return self.GetTextWidget().TextGetLastPosition( )


	def GetMaxLength( self ):
		#
		# Return the maximum allowable length of a text string entered from
		# the keyboard.
		#
		return self.GetTextWidget().TextGetMaxLength( )

		
	def GetSelection( self ):
		#
		# Return the value of the primiary selection
		#
		return self.GetTextWidget().TextGetSelection( )


	def GetString( self ):
		#
		# Return the contents (a copy) of the XmText widget
		#
		return self.GetTextWidget().TextGetString( )


	def GetTopCharacter( self ):
		#
		# Return the position of the first character displayed
		#
		return self.GetTextWidget().TextGetTopCharacter( )


	def GetLine( self, lineno ):
		#
		# Return the line 'lineno'
		#
		lineno = lineno - 1
		if lineno > 0 and lineno <= len(self.buffer):
			return self.buffer[lineno]
		else:
			return None

	# ------------------------------------------------------------------
	# Query methods:

	def IsEditable( self ): return self.editable


	# ------------------------------------------------------------------
	# Transform methods:

	def XYToPos( self, x, y ):
		#
		# Returns the character position nearest to an x,y position
		#
		self.GetTextWidget().TextXYToPos( x, y )


	# ------------------------------------------------------------------
	# Modify methods:

	def Insert( self, pos, str ):
		#
		# Insert a string into the current text string at a specified position
		#
		self.GetTextWidget().TextInsert( pos, str )


	def Paste( self ):
		#
		# Insert the (X) clipboard selection
		#
		self.GetTextWidget().TextPaste( )


	def Remove( self ):
		#
		# Delete the primary selection
		#
		self.GetTextWidget().TextRemove( )


	def Replace( self, from_pos, to_pos, txt ):
		#
		# Replace the text between two given positions with a new value
		#
		self.GetTextWidget().TextReplace( from_pos, to_pos, txt )


	def Scroll( self, nlines ):
		#
		# Scrolls the textview by nlines
		#
		self.GetTextWidget().TextScroll( nlines )


	def ScrollTo( self, lineno ):
		#
		# Scrolls the textview so the line 'lineno' is the first line displayed
		#
		cpos = 1
		for i in range(lineno-1):
			cpos = cpos + len(self.buffer[i])

		self.GetTextWidget().TextSetTopCharacter( cpos )

		

	def SetAddMode( self, state ):
		#
		# Set the 'addMode' to TRUE or FALSE
		#
		if state == vp.TRUE:
			state = X.TRUE
		elif state == vp.FALSE:
			state = X.FALSE
		self.GetTextWidget().TextSetAddMode( state )


	def SetEditable( self, state ):
		#
		# Set the 'editable' attribute to TRUE or FALSE
		#
		if state == vp.TRUE:
			self.editable = state
			state         = X.TRUE
		elif state == vp.FALSE:
			self.editable = vp.FALSE
			state         = X.FALSE
		self.GetTextWidget().TextSetEditable( state )

		
	def SetHighlight( self, left, right, mode ):
		#
		# Highlights text between two specified character positions. 'mode'
		# may have any of the following values:
		# Xmd.HIGHLIGHT_NORMAL - removes higlighting
		# Xmd.HIGHLIGHT_SELECTED - highlights the text in reverse video
		# Xmd.HIGHLIGHT_SECONDARY_SELECTED - highlights using underlining
		#
		self.GetTextWidget().TextSetHighlight( left, right, mode )


	def SetInsertionPosition( self, pos ):
		#
		# Sets the insert cursor position of the text widget
		#
		self.GetTextWidget().TextSetInsertionPosition( pos )


	def SetMaxLength( self, max ):
		#
		# Set the value of the current maximum allowable length of a text 
		# string entered from the keyboard.
		#
		self.GetTextWidget().TextSetMaxLength( max )
		
		
	def SetSelection( self, first, last, time ):
		#
		# Sets the primary selection of the text
		#
		self.GetTextWidget().SetSelection( first, last, time )


	def SetString( self, txt ):
		#
		# Set the contents of the text buffer of XmText to the given string
		#
		self.GetTextWidget().TextSetString( txt )


	def SetTopCharacter( self, top ):
		#
		# Sets the position of the first character displayed
		#
		self.GetTextWidget().TextSetTopCharacter( top )


	def ShowPosition( self, pos ):
		#
		# Forces text at a given position to be displayed
		#
		self.GetTextWidget().TextShowPosition( pos )




