# -------------------------------------------------------------------------
# MODULE:      RadioGroup
#
# DESCRIPTION: 
#     Contains the RadioGroup class
#
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, <per@cwi.nl>

import vp

from Object  import Object

class RadioGroup( Object ):

	def __init__( self, argdict = {} ):
		self.items = []             # the items in the group
		Object.__init__( self, argdict )

		self.curr_item = None

		for item in self.items:
			item.AddCallback( 'activate', self.SetCurrentItemCB )

	def SetCurrentItemCB( self, item ): 
		if self.curr_item != None and self.curr_item != item:
			self.curr_item.SetToggle( vp.OFF )
		self.curr_item = item

	
	# ------------------------------------------------------------------
	# Collaborator methods.

	def Register( self, item ): 
		self.items.append( item )
		item.AddCallback( 'activate', self.SetCurrentItemCB )


	def UnRegister( self, item ): 
		if item in self.items: 
			self.items.remove( item )
		item.RemoveCallback( 'activate', self.SetCurrentItemCB )
		


