# -------------------------------------------------------------------------
# MODULE:      OrnatedTreeNode
#
# DESCRIPTION: 
#     Contains the OrnatedTreeNode class.
#     
# AUTHOR:
#     Dirk Soede <soede@cwi.nl>, CWI, Amsterdam.

from TreeNode import TreeNode


# -------------------------------------------------------------------------
# CLASS:         OrnatedTreeNode
#
# INHERITS FROM: TreeNode
#
# DESCRIPTION:   A tree supplemented with directed links between
#                arbitrary nodes.
#


class OrnatedTreeNode( TreeNode ):

	# ------------------------------------------------------------------
	# Initialization

	def __init__( self ):
		TreeNode.__init__( self )
		self.outlinks = []
		self.inlinks  = []


	def Finalize( self ):
		self.outlinks = None
		self.inlinks  = None
		TreeNode.Finalize( self )


	# ------------------------------------------------------------------
	# Management of links.

	def AddLink( self, other ):
		self.outlinks.append( other )
		other.inlinks.append( self )


	def RemoveLink( self, other ):
		self.outlinks.remove( other )
		other.inlinks.remove( self )


	def GetOutlinks( self ):
		return self.outlinks


	def GetInlinks( self ):
		return self.inlinks

