# -------------------------------------------------------------------------
# MODULE:      Mixin 
#
# DESCRIPTION: 
#     Contains the super class for all Mixin classes
#
# AUTHOR:
#     Per Spilling <per@cwi.nl>, CWI, Amsterdam.

# -------------------------------------------------------------------------
# CLASS:         Mixin
#
# INHERITS FROM: None
#
# DESCRIPTION: 
#     The Mixin class is an abstract superclass for all mixin classes. It 
#     procides functionality for searching for an attribute (method or data) 
#     in a superclass.
#     

class Mixin:

	super_classes = {}  # A dict used to store lists with superclasses for
                        # every subclass of Mixin. These lists will be created
						# on demand when the GetSuperAttr() method is used. 
						# The lists are shared by all instances of a 
						# particluar class and are used to speed up the search
						# for an attribute in the GetSuperAttr() method.

	# ------------------------------------------------------------------
	# Protected methods:

	def GetSuperAttr( self, own_cl_obj, attr ):
		#
		# This method will search the super classes for a particular
		# attribute. The first attribute found will be returned.
		#
		sl = self.GetAllSuperClasses()

		for cl_obj in sl[sl.index(own_cl_obj):]:
			if hasattr( cl_obj, attr ) and cl_obj != own_cl_obj:
				return getattr( cl_obj, attr )

		return None


	# ------------------------------------------------------------------
	# Private methods:

	def GetAllSuperClasses( self ):
		cn = self.__class__.__name__

		if not Mixin.super_classes.has_key( cn ):
			Mixin.super_classes[cn] = []
			self._GetAllSuperClasses( self.__class__, Mixin.super_classes[cn] )

		return Mixin.super_classes[cn]


	def _GetAllSuperClasses( self, cl_obj, super_list ):
		if not cl_obj in super_list:
			super_list.append( cl_obj )

		for base in cl_obj.__bases__: 
			self._GetAllSuperClasses( base, super_list )

