# -------------------------------------------------------------------------
# MODULE:      MiscCommands
#
# DESCRIPTION: 
#     Contains some ready-to-use Command classes.
#
# ACKNOWLEDGEMENT:
#     The design of these classes have more or less been taken from the book:
#     "OOP w. C++ & Motif", D. Young, Prentice-Hall, 1992.
#    
# AUTHOR:
#     Per Spilling <per@cwi.nl>, CWI, Amsterdam.

import vp

from vp      import TRUE, FALSE
from Command import Command, WarnNoUndoCommand

debug = FALSE

# -------------------------------------------------------------------------
# CLASS:         UndoCommand
#
# INHERITS FROM: Command : Object
#
# DESCRIPTION: 
#     A concrete class of which there will be only one in the VPApp framework.
#     This instance can be accessed via the global variable:
#     > vp.theUndoCommand
#

class UndoCommand( Command ):

	# ------------------------------------------------------------------
	# Constructor 

	def __init__( self ):
		Command.__init__(self, {
			  'name'    : 'Undo',
			  'enabled' : FALSE,
			  'has_undo': FALSE
			  })

	# ------------------------------------------------------------------
	# Method overridden from Command class

	def Doit( self ):
		#
		# If there is a current command then execute it
		#
		if vp.theLastCommand != None:
			vp.theLastCommand.Undo()
			vp.theLastCommand = None     # only one level undo

	
# -------------------------------------------------------------------------
# CLASS:         QuitCommand
#
# INHERITS FROM: WarnNoUndoCommand : Command : Object
#
# DESCRIPTION: 
#     A concrete class of which there will be only one in the VPApp framework.
#     This instance can be accessed via the global variable:
#     > vp.theQuitCommand
#

class QuitCommand( WarnNoUndoCommand ):

	def __init__( self ):
		WarnNoUndoCommand.__init__(self, {'name': 'Quit', 'enabled': TRUE}) 
		self.SetQuestion( 'Do you really want to exit?' )

	def Doit( self ): vp.theApplication.Quit()


# -------------------------------------------------------------------------
# CLASS:         OpenFileCommand
#
# INHERITS FROM: Command : Object
#
# DESCRIPTION: 
#     A command for selecting filenames.
# 

class OpenFileCommand( Command ):

	def __init__( self, argdict = {} ):
		#
		# Args can be:
		# - 'name'    : <string> 'Select file...' = default
		# - 'callback': <callback method/function>
		# - 'enabled' : [TRUE=default|FALSE]
		# - 'pattern' : <regex pattern>
		#
		argdict = self.MergeDefaults( argdict, {
			'has_undo': FALSE,
			'name'    : 'Select file...'
			})
		Command.__init__( self, argdict ) 


	def Doit( self ):
		if hasattr( self, 'pattern' ):
			vp.theFileSelectionDialog.SetPattern( self.pattern )
		vp.theFileSelectionDialog.Post( '', self.OkCB, None, None )


	def OkCB( self, dialog ):
		filename = vp.theFileSelectionDialog.GetFilename()
		if debug: print 'OpenFileCommand.OkCB: filename =', filename
		if hasattr( self, 'callback'): self.callback( filename )


# -------------------------------------------------------------------------
# CLASS:         CallbackCommand
#
# INHERITS FROM: Command : Object
#
# DESCRIPTION: 
#     A concrete class which will call a callback method or function when
#     triggered. 
#

class CallbackCommand( Command ):

	def __init__( self, argdict = {} ):
		#
		# Args can be:
		# - 'name'    : <string> (required)
		# - 'callback': <callback method/function>
		# - 'enabled' : [TRUE=default|FALSE]
		# 
		argdict = self.MergeDefaults( argdict, {'has_undo': FALSE} )
		Command.__init__( self, argdict ) 


	def Doit( self ):
		if debug: print 'CallbackCommand.Doit called'
		if hasattr( self, 'callback'): self.callback()


