# -------------------------------------------------------------------------
# MODULE:      Control
#
# DESCRIPTION: 
#     Contains the Control class.
#
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, per@cwi.nl
#

import Xm, Xmd, X

import vp

from Object       import Object
from Mixin        import Mixin
from WidgetObject import WidgetObject

debug       = vp.FALSE
debug_final = vp.FALSE

# -------------------------------------------------------------------------
# CLASS:         Control
#
# INHERITS FROM: Mixin
#
# DESCRIPTION: 
#     A mixin class for all Control classes.
#

class Control( Mixin ):

	# ------------------------------------------------------------------
	# Initialization methods

	def __init__( self, argdict = {} ):    
		#
		# Args can be the following: 
		# - 'name'          : <string>
		# - 'callback'      : <activate-callback function/method instance>
		# - 'command'       : <command instance>
		#
		self.enabled  = vp.TRUE
		self.callback = None
		self.command  = None

		apply(self.GetSuperAttr(Control, '__init__'), (self, argdict))

		if self.command != None:
			self.command.Register( self )
			self.name = self.command.GetName()

		elif self.callback != None:
			Object.AddCallback( self, 'activate', self.callback )
		

	def InitWidget( self ):
		if not self.IsRealized():
			self.GetSuperAttr( Control, 'InitWidget' )( self )

		if self.enabled:
			self.Enable()
		else:
			self.Disable()


	def Finalize( self ):
		if debug_final:
			print 'Control.Finalize called for', self.GetClassName()

		if self.command != None:
			self.command.UnRegister( self )

		self.command  = None
		self.callback = None

		self.GetSuperAttr( Control, 'Finalize' )( self )


	def ProcessArgs( self, argdict ):
		for key in argdict.keys():
			if key in ['callback', 'command']:
				setattr( self, key, argdict[key] )
				del argdict[key]

		self.GetSuperAttr(Control,'ProcessArgs')( self, argdict )

		
	# ------------------------------------------------------------------
	# Command related methods

	def Enable( self ):
		if debug: print self.GetName(), 'enabled'

		if self.IsRealized() and hasattr( self, 'w'): 
			self.w.SetSensitive( X.TRUE )
		self.enabled = vp.TRUE
		

	def Disable( self ):
		if debug: print self.GetName(), 'disabled'

		if self.IsRealized() and hasattr( self, 'w'): 
			self.w.SetSensitive( X.FALSE )
		self.enabled = vp.FALSE

		
	# ------------------------------------------------------------------
	# Misc. 'protected' methods, i.e. methods which should only be used
	# by subclasses.

	def ExecuteCallback( self, cb_type, cb_data ):
		#
		# Execute a command or call a callback method/function
		#
		if debug: 
			print 'Control.ExecuteCallback:', cb_type, 'for', self.GetName()
			
		if cb_type == 'activate' and self.command != None:
			self.command.Execute()
		self.GetSuperAttr(Control, 'ExecuteCallback')( self, cb_type, cb_data )


	# ------------------------------------------------------------------
	# Access methods

	def GetCommand( self ): return self.command

	

