# -------------------------------------------------------------------------
# MODULE:      ConstraintUtils
#
# DESCRIPTION:
#     Utility functions for setting geometric constraints.
#

import vp
from Datum       import Datum, Max

debug = vp.FALSE

# -------------------------------------------------------------------------

def SetEqualWidthConstraint( wobject_list ):
	width_datums = []

	for wobject in wobject_list:
		width_datums.append( wobject.GetDatum('width') )

	if len(width_datums) > 1:
		if debug:
			print 'width_datums =', width_datums
		
		mx = Max()
		for wdatum in width_datums:
			mx.AddInput( wdatum )
			mx.LinkTo( wdatum )

# -------------------------------------------------------------------------

def SetEqualHeightConstraint( wobject_list ):
	height_datums = []

	for wobject in wobject_list:
		height_datums.append( wobject.GetDatum('height') )

	if len(height_datums) > 1:
		if debug:
			print 'height_datums =', height_datums

		mx = Max()
		for hdatum in height_datums:
			mx.AddInput( hdatum )
			mx.LinkTo( hdatum )

# -------------------------------------------------------------------------

def SetEqualSizeConstraint( wobject_list ):
	SetEqualWidthConstraint( wobject_list )
	SetEqualHeightConstraint( wobject_list )

# -------------------------------------------------------------------------
##
##def SetRowTopConstraint( wobject_list ):
##	if len(wobject_list) > 1:
##		from Datum import Add
##
##		for i in range(1,len(wobject_list)):
##			prev = wobject_list[i-1]
##			next = wobject_list[i]
##
##			xdist = Add( prev.GetDatum('x'), prev.GetDatum('width') )
##			xdist.LinkTo( next.GetDatum('x') )
##			prev.GetDatum('y').LinkTo( next.GetDatum('y') )
##
##	
##def SetRowCenterConstraint( wobject_list ):
##	if len(wobject_list) > 1:
##		from Datum import Add, Divide
##
##		for i in range(1,len(wobject_list)):
##			prev = wobject_list[i-1]
##			next = wobject_list[i]
##
##			xdist = Add( prev.GetDatum('x'), prev.GetDatum('width') )
##			xdist.LinkTo( next.GetDatum('x') )
##			ydist = Add( prev.GetDatum('y'), Divide(prev.GetDatum('height'),2))
##			ydist.LinkTo( next.GetDatum('y') )
##
##
##def SetRowBottomConstraint( wobject_list ):
##	if len(wobject_list) > 1:
##		from Datum import Add, Divide
##
##		first = wobject_list[0]
##		bottom = Add( first.GetDatum('y'), first.GetDatum('height') )
##
##		for i in range(1,len(wobject_list)):
##			prev = wobject_list[i-1]
##			next = wobject_list[i]
##
##			xdist = Add( prev.GetDatum('x'), prev.GetDatum('width') )
##			xdist.LinkTo( next.GetDatum('x') )
##			bottom.DoubleLinkTo( Add(next.GetDatum('y'),next.GetDatum('height')) )
##
##
##	
