# -------------------------------------------------------------------------
# MODULE:      Canvas
#
# DESCRIPTION: 
#     Contains the Canvas class.
#
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, <per@cwi.nl>
#  

import Xm, Xmd, X			# Xt & Motif stuff

import vp, EventNotifier

from vp            import TRUE, FALSE
from WidgetObject  import WidgetObject
from Composite     import Composite

debug = FALSE

# -------------------------------------------------------------------------
# CLASS:         Canvas
#
# INHERITS FROM: (Composite,WidgetObject) : Graphic: (DatumDict, TreeNode) :\
#                 Object
#
# DESCRIPTION: 
#

class Canvas( Composite, WidgetObject ):

	widget_class = Xm.DrawingArea

	# ------------------------------------------------------------------
	# Init methods 

	def __init__( self, argdict = {} ):
		argdict = self.MergeDefaults( argdict, {'selection_rect': FALSE} )
		Composite.__init__( self, argdict ) 

		self.SetDefaultXRes()

		if self.selection_rect == TRUE:
			self.making_selection = FALSE
			from Sketcher import RubberRectSketcher

			self.sketcher = RubberRectSketcher({ 'canvas': self })
			self.Subscribe( vp.MOUSE_DOWN, self.MouseDownEH, None )
			self.Subscribe( vp.MOUSE1_DRAG, self.Mouse1DragEH, None )
			self.Subscribe( vp.MOUSE_UP, self.MouseUpEH, None )


	def SetDefaultXRes( self ):
		self.SetXResources({
			  'resizePolicy': Xmd.RESIZE_NONE,
			  'marginWidth' : 0,
			  'marginHeight': 0
			  })


	# ------------------------------------------------------------------
	# Event notification methods:

	def MouseDownEH( self, target, client_data, xevent, e ):
		if e == None: e = xevent       # XButtonEvent

		self.making_selection = FALSE
		self.mouse_pos = (e.x_root, e.y_root)

		if e.button == X.Button1 and self.selection_rect \
			  and not self.show_cntrl_pnts:            # start selection drag
			self._StartSelectionDrag( client_data, xevent, e )

		elif e.button == X.Button3 and hasattr( self, '_popup' ):
			vp.theCurrentPopupNode = self
			self._popup.Show( xevent )

		elif self.draggable and e.button == X.Button2: # start self drag
			EventNotifier.NotifyExpose( FALSE )        
			EventNotifier.GrabFocus( self )       
			if self.show_cntrl_pnts:
				self.Redraw = self._DrawControlPoints  # no need to redraw self

		elif e.button == X.Button1:
			if self.show_cntrl_pnts:
				EventNotifier.NotifyExpose( FALSE )        
				EventNotifier.GrabFocus( self )        # start resizing
			else:
				vp.theSelection.SetEmpty()          
				self.SetSelected( TRUE )


	def Mouse1DragEH( self, target, client_data, xevent, e ):
		if self.selection_rect and self.making_selection:
			self.sketcher.Mouse1DragEH( target, client_data, xevent, e )
		else:
			WidgetObject.Mouse1DragEH( self, target, client_data, xevent, e )


	def MouseUpEH( self, target, client_data, xevent, e ): 
		if e == None: e = xevent       # XButtonEvent

		EventNotifier.GrabFocus( None )
		EventNotifier.NotifyExpose( TRUE )

		if self.selection_rect and self.making_selection:
			self._EndSelectionDrag( client_data, xevent, e )
			if vp.theSelection.IsEmpty(): 
				vp.theSelection.Add( self )

		elif self.draggable and e.button == X.Button2: # end self drag
			if self.show_cntrl_pnts:
				self.Redraw = self._RedrawWithControlPoints


	# ------------------------------------------------------------------
	# Private util methods 

	def _StartSelectionDrag( self, client_data, xevent, e ):
		self.making_selection = TRUE
		vp.theSelection.SetEmpty()
		self.sketcher.MouseDownEH( self, client_data, xevent, e )
		EventNotifier.GrabFocus( self )   


	def _EndSelectionDrag( self, client_data, xevent, e ):
		self.sketcher.MouseUpEH( self, client_data, xevent, e )
		self.making_selection = FALSE
		r = self.sketcher.GetGeometry()

		# Check if any children where selected

		for child in self.children:
			bb = child.GetBBox()
			if r[0] < bb[0] and r[1] < bb[1] and r[2] > bb[2] and r[3] > bb[3]:
				child.SetSelected( TRUE )

