"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.
"""

false, true = 0, 1
import strop

URLNotFound = "XMLProcessor.URLNotFound"

# exception reporting
def exc():
	import sys					

	print "---     exception      ---"
	print "Error in dtm._proc(): "	
	print sys.exc_type, sys.exc_value
	print "--- stack trace        ---"

	# use some stuff from the python debugger
        import pdb

        x = pdb.Pdb()
        x.setup(None, sys.exc_traceback)
	for s in x.stack:	
		x.print_stack_entry(s)


"""
	Base class for all XMLProcessors
"""
class XMLProcessor:
	def __init__(self, client, bufsize = 4096):
		from XMLFactory import XMLFactory
		self.bufsize = bufsize
		self.factory = XMLFactory(client)
		# for better debugger
		self.linecnt = 1

	def getClient(self):
		return self.factory.getClient()
	
	def run(self, url, verbose = 0):
		import urllib, time

		self.urlname = url
		try:
			# get the url 
			self.fn, h = urllib.urlretrieve(url)
			# open the file
			try:
				file = open(self.fn, 'r')
			except:
				raise URLNotFound, "Unable to open %s" % (url)
		except:
			# try to get the file locally
			try:
				file = open(url,'r')
			except:
				raise URLNotFound, "Unable to open %s" % (url)
		starttime = time.time()
		totalbytes = 0
		print "[XMLProcessor] begining to process %s" % (url)	

		while 1:
			data = file.read( self.bufsize )

			if data == None: break
			if len(data) == 0: break

			totalbytes = totalbytes + len(data)

			if verbose == 1:
				print data

			try:
				if self.factory.feed(data) == true:
					return true
			except:
				print "Error at line ",self.factory.linecnt," in ", url	
				exc()						
				return
	
		del file
		if self.factory.client.abortProcess() == false:
			self.factory.endfile()
		
		print ""		
		print "[XMLProcessor] total execution time ",time.time()-starttime," seconds. File size = ", totalbytes
		


class XPointerProcessor:
	def run(self, command, url, pattern, nummatches):
		import urllib
		from XMLClient import XPointerClient, XPointerErr, FoundTarget, TargetNotFound
		from XMLFactory import URLNotFound, XMLFactory
		errmsg = ""

		client = XPointerClient(command, pattern, nummatches) 
		self.factory = XMLFactory(client)
		file = None
	
		fn, h = urllib.urlretrieve(url)
		# open the file
		try:
			file = open(fn, 'r')
		except:
			raise URLNotFound, "Unable to open %s" % (url)
			
		while 1:
			line = file.readline()
			if line == None:
				break
			if len(line) == 0:
				break
			try:
				self.factory.feed( line )
			except FoundTarget:
				return client.target
				
			
		del file
		self.factory.endfile()
		return None
