/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char timer_create__doc__[] =
"Creates a timer"
;

static PyObject *
timer_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long    o;
	int     t,x,y,w,h;
	char    *l;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_timer(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char timer_set__doc__[] =
"Set the time remaining in a timer object"
;

static PyObject *
timer_set(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	v;

	if (!PyArg_ParseTuple(args, "ld",&o,&v))
		return NULL;
	fl_set_timer((FL_OBJECT *)o,v);
	Py_INCREF(Py_None);
	return Py_None;
}

static char timer_get__doc__[] =
"Get the time remaining in a timer object"
;

static PyObject *
timer_get(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	v;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	v=fl_get_timer((FL_OBJECT *)o);
	return Py_BuildValue ("d",v);
}

/* List of methods defined in the module */

static struct PyMethodDef timer_methods[] = {
	{"create",	timer_create,	1,	timer_create__doc__},
 {"set",	timer_set,	1,	timer_set__doc__},
 {"get",	timer_get,	1,	timer_get__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called inittimer) */

static char timer_module_documentation[] = 
""
;

void
inittimer()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("timer", timer_methods,
		timer_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("timer.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module timer");
}

