/***********************************************************
Copyright 1991-1995 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char pup_new__doc__[] =
""
;

static PyObject *
pup_new(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_def__doc__[] =
""
;

static PyObject *
pup_def(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_addto__doc__[] =
""
;

static PyObject *
pup_addto(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set__doc__[] =
""
;

static PyObject *
pup_set(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_free__doc__[] =
""
;

static PyObject *
pup_free(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_do__doc__[] =
""
;

static PyObject *
pup_do(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_shortcut__doc__[] =
""
;

static PyObject *
pup_set_shortcut(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_position__doc__[] =
""
;

static PyObject *
pup_set_position(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_selection__doc__[] =
""
;

static PyObject *
pup_set_selection(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_fontsize__doc__[] =
""
;

static PyObject *
pup_set_fontsize(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_fontstyle__doc__[] =
""
;

static PyObject *
pup_set_fontstyle(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_shadow__doc__[] =
""
;

static PyObject *
pup_set_shadow(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_softedge__doc__[] =
""
;

static PyObject *
pup_set_softedge(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_color__doc__[] =
""
;

static PyObject *
pup_set_color(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_title__doc__[] =
""
;

static PyObject *
pup_set_title(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_itemcb__doc__[] =
""
;

static PyObject *
pup_set_itemcb(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_menucb__doc__[] =
""
;

static PyObject *
pup_set_menucb(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char pup_set_submenu__doc__[] =
""
;

static PyObject *
pup_set_submenu(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef pup_methods[] = {
	{"new",	pup_new,	1,	pup_new__doc__},
 {"def",	pup_def,	1,	pup_def__doc__},
 {"addto",	pup_addto,	1,	pup_addto__doc__},
 {"set",	pup_set,	1,	pup_set__doc__},
 {"free",	pup_free,	1,	pup_free__doc__},
 {"do",	pup_do,	1,	pup_do__doc__},
 {"set_shortcut",	pup_set_shortcut,	1,	pup_set_shortcut__doc__},
 {"set_position",	pup_set_position,	1,	pup_set_position__doc__},
 {"set_selection",	pup_set_selection,	1,	pup_set_selection__doc__},
 {"set_fontsize",	pup_set_fontsize,	1,	pup_set_fontsize__doc__},
 {"set_fontstyle",	pup_set_fontstyle,	1,	pup_set_fontstyle__doc__},
 {"set_shadow",	pup_set_shadow,	1,	pup_set_shadow__doc__},
 {"set_softedge",	pup_set_softedge,	1,	pup_set_softedge__doc__},
 {"set_color",	pup_set_color,	1,	pup_set_color__doc__},
 {"set_title",	pup_set_title,	1,	pup_set_title__doc__},
 {"set_itemcb",	pup_set_itemcb,	1,	pup_set_itemcb__doc__},
 {"set_menucb",	pup_set_menucb,	1,	pup_set_menucb__doc__},
 {"set_submenu",	pup_set_submenu,	1,	pup_set_submenu__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initpopups) */

static char popups_module_documentation[] = 
""
;

void
initpopups()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("popups", pup_methods,
		popups_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("popups.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module popups");
}

