/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char pmp_create__doc__[] =
"Creates a pixmap"
;

static PyObject *
pmp_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int		t,x,y,w,h;
	char		*l;
	FL_OBJECT	*o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=fl_create_pixmap(t,x,y,w,h,l);
	return Py_BuildValue ("l",(long)o);
}

static char pmp_set_data__doc__[] =
"Sets the pixmap's data"
;

static PyObject *
pmp_set_data(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    o;
	long    b;

	if (!PyArg_ParseTuple(args, "ll",&o,&b))
		return NULL;
	fl_set_pixmap_data((FL_OBJECT *)o,(char **)b);
	Py_INCREF(Py_None);
	return Py_None;
}



static char pmp_set_file__doc__[] =
"Loads a file into a pixmap"
;

static PyObject *
pmp_set_file(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    o;
	char    *f;

	if (!PyArg_ParseTuple(args, "ls",&o,&f))
		return NULL;
	fl_set_pixmap_file((FL_OBJECT *)o,f);
	Py_INCREF(Py_None);
	return Py_None;
}


/* List of methods defined in the module */

static struct PyMethodDef pmp_methods[] = {
 {"create",	pmp_create,	1,	pmp_create__doc__},
 {"set_data",	pmp_set_data,	1,	pmp_set_data__doc__},
 {"set_file",	pmp_set_file,	1,	pmp_set_file__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initpixmap) */

static char pixmaps_module_documentation[] = 
""
;

void
initpixmaps()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("pixmaps", pmp_methods,
		pixmaps_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("pixmaps.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module pixmaps");
}

